/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.util.transport.SubscriberUnAvailableException;

public class InMemoryBroker {
    private static final MessageBroker broker = new MessageBroker();

    public static void subscribe(Subscriber subscriber) {
        broker.register(subscriber);
    }

    public static void unsubscribe(Subscriber subscriber) {
        broker.unregister(subscriber);
    }

    public static void publish(String topic, Object message) throws SubscriberUnAvailableException {
        broker.publish(topic, message);
    }

    private static class MessageBroker
    implements Broker {
        private final Object mutex = new Object();
        private Map<String, List<Subscriber>> topicSubscribers = new HashMap<String, List<Subscriber>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void register(final Subscriber subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("Subscriber cannot be null.");
            }
            Object object = this.mutex;
            synchronized (object) {
                if (this.topicSubscribers.containsKey(subscriber.getTopic())) {
                    if (!this.topicSubscribers.get(subscriber.getTopic()).contains(subscriber)) {
                        ArrayList<Subscriber> list = new ArrayList<Subscriber>((Collection)this.topicSubscribers.get(subscriber.getTopic()));
                        list.add(subscriber);
                        this.topicSubscribers.put(subscriber.getTopic(), list);
                    }
                } else {
                    this.topicSubscribers.put(subscriber.getTopic(), (List<Subscriber>)new ArrayList<Subscriber>(){
                        {
                            this.add(subscriber);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister(Subscriber subscriber) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    ArrayList list = new ArrayList(this.topicSubscribers.get(subscriber.getTopic()));
                    list.remove(subscriber);
                    this.topicSubscribers.put(subscriber.getTopic(), list);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void broadcast(String topic, Object msg) throws SubscriberUnAvailableException {
            if (this.topicSubscribers.containsKey(topic) && !this.topicSubscribers.get(topic).isEmpty()) {
                List<Subscriber> subscribers = this.topicSubscribers.get(topic);
                for (Subscriber subscriber : subscribers) {
                    subscriber.onMessage(msg);
                }
            } else {
                throw new SubscriberUnAvailableException("Subscriber for topic '" + topic + "' is unavailable.");
            }
        }

        public void publish(String topic, Object msg) throws SubscriberUnAvailableException {
            this.broadcast(topic, msg);
        }
    }

    public static interface Subscriber {
        public void onMessage(Object var1);

        public String getTopic();
    }

    static interface Broker {
        public void register(Subscriber var1);

        public void unregister(Subscriber var1);

        public void broadcast(String var1, Object var2) throws SubscriberUnAvailableException;
    }
}

