/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.transport;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.util.transport.Option;
import org.wso2.siddhi.core.util.transport.TemplateBuilder;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

public class OptionHolder {
    private Map<String, Option> options = new HashMap<String, Option>();
    private Extension extension;
    private Set<String> dynamicOptionsKeys = new HashSet<String>();
    private Set<String> staticOptionsKeys = new HashSet<String>();

    public OptionHolder(StreamDefinition streamDefinition, Map<String, String> staticOptions, Map<String, String> dynamicOptions, Extension extension) {
        this.extension = extension;
        for (Map.Entry<String, String> entry : staticOptions.entrySet()) {
            this.options.put(entry.getKey(), new Option(entry.getKey(), entry.getValue(), null));
        }
        for (Map.Entry<String, String> entry : dynamicOptions.entrySet()) {
            this.options.put(entry.getKey(), new Option(entry.getKey(), null, new TemplateBuilder(streamDefinition, entry.getValue())));
        }
        for (String key : staticOptions.keySet()) {
            this.staticOptionsKeys.add(key);
        }
        for (String key : dynamicOptions.keySet()) {
            this.dynamicOptionsKeys.add(key);
        }
    }

    public Option validateAndGetOption(String optionKey) {
        Option option = this.options.get(optionKey);
        if (option == null) {
            throw new SiddhiAppValidationException("Option '" + optionKey + "' does not exist in the configuration of '" + this.extension.namespace() + ":" + this.extension.name() + "'.");
        }
        return option;
    }

    public Option getOrCreateOption(String optionKey, String defaultValue) {
        Option option = this.options.get(optionKey);
        if (option == null) {
            option = new Option(optionKey, defaultValue, null);
        }
        return option;
    }

    Option getOrAddStaticOption(String optionKey, String value) {
        Option option = this.options.get(optionKey);
        if (option == null) {
            option = new Option(optionKey, value, null);
            this.options.put(optionKey, option);
        }
        return option;
    }

    public String validateAndGetStaticValue(String optionKey, String defaultValue) {
        Option option = this.options.get(optionKey);
        if (option != null) {
            if (!option.isStatic()) {
                throw new SiddhiAppValidationException("'" + optionKey + "' is not a 'static' option in the configuration of " + this.extension.namespace() + ":" + this.extension.name() + ".");
            }
            return option.getValue();
        }
        return defaultValue;
    }

    public String validateAndGetStaticValue(String optionKey) {
        Option option = this.options.get(optionKey);
        if (option != null) {
            if (!option.isStatic()) {
                throw new SiddhiAppValidationException("'" + optionKey + "' is defined as a 'dynamic' option but it has to be a 'static' option for the " + this.extension.namespace() + ":" + this.extension.name() + " configuration.");
            }
            return option.getValue();
        }
        throw new SiddhiAppValidationException("'" + optionKey + "' 'static' option is not defined in the configuration of " + this.extension.namespace() + ":" + this.extension.name() + ".");
    }

    OptionHolder merge(OptionHolder optionHolderToMerge) {
        optionHolderToMerge.getDynamicOptionsKeys().forEach(key -> {
            Option optionToMerge = optionHolderToMerge.validateAndGetOption((String)key);
            this.options.put((String)key, optionToMerge);
            this.dynamicOptionsKeys.add((String)key);
        });
        optionHolderToMerge.getStaticOptionsKeys().forEach(key -> {
            Option optionToMerge = optionHolderToMerge.validateAndGetOption((String)key);
            this.options.put((String)key, optionToMerge);
            this.staticOptionsKeys.add((String)key);
        });
        return this;
    }

    public boolean isOptionExists(String optionKey) {
        return this.options.get(optionKey) != null;
    }

    public Set<String> getDynamicOptionsKeys() {
        return this.dynamicOptionsKeys;
    }

    public Set<String> getStaticOptionsKeys() {
        return this.staticOptionsKeys;
    }
}

