/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashSet;

@Extension(name="createSet", namespace="", description="Includes the given input parameter in a java.util.HashSet and returns the set. ", parameters={@Parameter(name="input", description="The input that needs to be added into the set.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL})}, returnAttributes={@ReturnAttribute(description="The set that includes the input element.", type={DataType.OBJECT})}, examples={@Example(syntax="from stockStream \nselect createSet(symbol) as initialSet \ninsert into initStream;", description="For every incoming stockStream event, the initStream stream will produce a set object having only one element: the symbol in the incoming stockStream.")})
public class CreateSetFunctionExecutor
extends FunctionExecutor {
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("createSet() function has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        if (!this.isAttributeTypeSupported(attributeExpressionExecutors[0].getReturnType())) {
            throw new OperationNotSupportedException("createSet() function not supported for type: " + attributeExpressionExecutors[0].getReturnType());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(data);
        return set;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    private boolean isAttributeTypeSupported(Attribute.Type type) {
        switch (type) {
            case FLOAT: {
                return true;
            }
            case INT: {
                return true;
            }
            case LONG: {
                return true;
            }
            case DOUBLE: {
                return true;
            }
            case STRING: {
                return true;
            }
            case BOOL: {
                return true;
            }
        }
        return false;
    }
}

