/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.SchedulingProcessor;
import io.siddhi.core.query.processor.stream.window.BatchingFindableWindowProcessor;
import io.siddhi.core.query.processor.stream.window.FindableProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Extension(name="timeBatch", namespace="", description="A batch (tumbling) time window that holds and process events that arrive during 'window.time' period as a batch.", parameters={@Parameter(name="window.time", description="The batch time period in which the window process the events.", type={DataType.INT, DataType.LONG, DataType.TIME}), @Parameter(name="start.time", description="This specifies an offset in milliseconds in order to start the window at a time different to the standard time.", type={DataType.INT}, optional=true, defaultValue="Timestamp of first event"), @Parameter(name="stream.current.event", description="Let the window stream the current events out as and when they arrive to the window while expiring them in batches.", type={DataType.BOOL}, optional=true, defaultValue="false")}, examples={@Example(syntax="define stream InputEventStream (symbol string, price float, volume int);\n\n@info(name = 'query1')\nfrom InputEventStream#timeBatch(20 sec)\nselect symbol, sum(price) as price \ninsert into OutputStream;", description="This collect and process incoming events as a batch every 20 seconds and output them."), @Example(syntax="define stream InputEventStream (symbol string, price float, volume int);\n\n@info(name = 'query1')\nfrom InputEventStream#timeBatch(20 sec, true)\nselect symbol, sum(price) as sumPrice \ninsert into OutputStream;", description="This window sends the arriving events directly to the output letting the `sumPrice` to increase gradually and on every 20 second interval it clears the window as a batch resetting the `sumPrice` to zero."), @Example(syntax="define stream InputEventStream (symbol string, price float, volume int);\ndefine window StockEventWindow (symbol string, price float, volume int) timeBatch(20 sec) output all events;\n\n@info(name = 'query0')\nfrom InputEventStream\ninsert into StockEventWindow;\n\n@info(name = 'query1')\nfrom StockEventWindow\nselect symbol, sum(price) as price\ninsert all events into OutputStream ;", description="This uses an defined window to process events arrived every 20 seconds as a batch and output all events.")})
public class TimeBatchWindowProcessor
extends BatchingFindableWindowProcessor<WindowState>
implements SchedulingProcessor,
FindableProcessor {
    private long timeInMilliSeconds;
    private long nextEmitTime = -1L;
    private Scheduler scheduler;
    private boolean outputExpectsExpiredEvents;
    private SiddhiQueryContext siddhiQueryContext;
    private boolean isStartTimeEnabled = false;
    private boolean isStreamCurrentEvents = false;
    private long startTime = 0L;

    public void setTimeInMilliSeconds(long timeInMilliSeconds) {
        this.timeInMilliSeconds = timeInMilliSeconds;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        this.siddhiQueryContext = siddhiQueryContext;
        if (attributeExpressionExecutors.length == 1) {
            this.initTimeParameter(attributeExpressionExecutors[0]);
            return () -> new WindowState(streamEventClonerHolder, outputExpectsExpiredEvents, findToBeExecuted);
        } else if (attributeExpressionExecutors.length == 2) {
            this.initTimeParameter(attributeExpressionExecutors[0]);
            if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
                throw new SiddhiAppValidationException("TimeBatch window's window.time (2nd) parameter should be constant but found a dynamic attribute " + attributeExpressionExecutors[1].getClass().getCanonicalName());
            }
            if (attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT) {
                this.isStartTimeEnabled = true;
                this.startTime = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
                return () -> new WindowState(streamEventClonerHolder, outputExpectsExpiredEvents, findToBeExecuted);
            } else if (attributeExpressionExecutors[1].getReturnType() == Attribute.Type.LONG) {
                this.isStartTimeEnabled = true;
                this.startTime = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
                return () -> new WindowState(streamEventClonerHolder, outputExpectsExpiredEvents, findToBeExecuted);
            } else {
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.BOOL) throw new SiddhiAppValidationException("TimeBatch window's 2nd parameter should be 'start.time' which is int or long, or 'stream.current.event' which is bool  but found " + attributeExpressionExecutors[1].getReturnType());
                this.isStreamCurrentEvents = Boolean.valueOf(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
            }
            return () -> new WindowState(streamEventClonerHolder, outputExpectsExpiredEvents, findToBeExecuted);
        } else {
            if (attributeExpressionExecutors.length != 3) throw new SiddhiAppValidationException("Time window should only have one or two parameters. (<int|long|time> windowTime), but found " + attributeExpressionExecutors.length + " input attributes");
            this.initTimeParameter(attributeExpressionExecutors[0]);
            if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
                throw new SiddhiAppValidationException("TimeBatch window's window.time (2nd) parameter 'start.time' should be a constant but found a dynamic attribute " + attributeExpressionExecutors[1].getClass().getCanonicalName());
            }
            this.isStartTimeEnabled = true;
            if (attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT) {
                this.startTime = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
            } else {
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) throw new SiddhiAppValidationException("TimeBatch window's 2nd parameter should be 'start.time' which is int or long,  but found " + attributeExpressionExecutors[1].getReturnType());
                this.startTime = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
            }
            if (!(attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor)) {
                throw new SiddhiAppValidationException("TimeBatch window's window.time (3rd) parameter 'stream.current.event' should be a constant but found a dynamic attribute " + attributeExpressionExecutors[2].getClass().getCanonicalName());
            }
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.BOOL) throw new SiddhiAppValidationException("TimeBatch window's 3rd parameter should be 'stream.current.event' which is bool  but found " + attributeExpressionExecutors[2].getReturnType());
            this.isStreamCurrentEvents = Boolean.valueOf(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue()));
        }
        return () -> new WindowState(streamEventClonerHolder, outputExpectsExpiredEvents, findToBeExecuted);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initTimeParameter(ExpressionExecutor attributeExpressionExecutor) {
        if (!(attributeExpressionExecutor instanceof ConstantExpressionExecutor)) throw new SiddhiAppValidationException("TimeBatch window's window.time (1st) parameter 'window.time' should be a constant but found a dynamic attribute " + attributeExpressionExecutor.getClass().getCanonicalName());
        if (attributeExpressionExecutor.getReturnType() == Attribute.Type.INT) {
            this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutor).getValue()).intValue();
            return;
        } else {
            if (attributeExpressionExecutor.getReturnType() != Attribute.Type.LONG) throw new SiddhiAppValidationException("TimeBatch window's window.time (1st) parameter 'window.time' should be either int or long, but found " + attributeExpressionExecutor.getReturnType());
            this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutor).getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        WindowState windowState = state;
        synchronized (windowState) {
            boolean sendEvents;
            long currentTime;
            if (this.nextEmitTime == -1L) {
                currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
                this.nextEmitTime = this.isStartTimeEnabled ? this.getNextEmitTime(currentTime) : this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime() + this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.nextEmitTime);
            }
            if ((currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime()) >= this.nextEmitTime) {
                this.nextEmitTime += this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.nextEmitTime);
                sendEvents = true;
            } else {
                sendEvents = false;
            }
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                if (streamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                if (state.resetEvent == null) {
                    state.resetEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    state.resetEvent.setType(ComplexEvent.Type.RESET);
                }
                if (!this.isStreamCurrentEvents) {
                    state.currentEventQueue.add(clonedStreamEvent);
                    continue;
                }
                if (state.expiredEventQueue == null) continue;
                clonedStreamEvent.setType(ComplexEvent.Type.EXPIRED);
                state.expiredEventQueue.add(clonedStreamEvent);
            }
            if (!this.isStreamCurrentEvents) {
                streamEventChunk.clear();
            }
            if (sendEvents) {
                if (this.outputExpectsExpiredEvents && state.expiredEventQueue.getFirst() != null) {
                    while (state.expiredEventQueue.hasNext()) {
                        StreamEvent expiredEvent = state.expiredEventQueue.next();
                        expiredEvent.setTimestamp(currentTime);
                    }
                    streamEventChunk.add(state.expiredEventQueue.getFirst());
                    state.expiredEventQueue.clear();
                }
                if (state.resetEvent != null) {
                    streamEventChunk.add(state.resetEvent);
                    state.resetEvent = null;
                }
                if (state.currentEventQueue != null && state.currentEventQueue.getFirst() != null) {
                    if (state.expiredEventQueue != null) {
                        state.currentEventQueue.reset();
                        while (state.currentEventQueue.hasNext()) {
                            StreamEvent currentEvent = state.currentEventQueue.next();
                            StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEvent);
                            toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                            state.expiredEventQueue.add(toExpireEvent);
                        }
                    }
                    streamEventChunk.add(state.currentEventQueue.getFirst());
                    state.currentEventQueue.clear();
                }
            }
        }
        if (streamEventChunk.getFirst() != null) {
            streamEventChunk.setBatch(true);
            nextProcessor.process(streamEventChunk);
            streamEventChunk.setBatch(false);
        }
    }

    private long getNextEmitTime(long currentTime) {
        long elapsedTimeSinceLastEmit = (currentTime - this.startTime) % this.timeInMilliSeconds;
        long emitTime = currentTime + (this.timeInMilliSeconds - elapsedTimeSinceLastEmit);
        return emitTime;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.expiredEventQueue, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.expiredEventQueue, streamEventCloner);
    }

    class WindowState
    extends State {
        private SnapshotableStreamEventQueue currentEventQueue;
        private SnapshotableStreamEventQueue expiredEventQueue;
        private StreamEvent resetEvent = null;

        WindowState(StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted) {
            if (!TimeBatchWindowProcessor.this.isStreamCurrentEvents) {
                this.currentEventQueue = new SnapshotableStreamEventQueue(streamEventClonerHolder);
            }
            if (outputExpectsExpiredEvents || findToBeExecuted) {
                this.expiredEventQueue = new SnapshotableStreamEventQueue(streamEventClonerHolder);
            }
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("CurrentEventQueue", this.currentEventQueue != null ? this.currentEventQueue.getSnapshot() : null);
            state.put("ExpiredEventQueue", this.expiredEventQueue != null ? this.expiredEventQueue.getSnapshot() : null);
            state.put("ResetEvent", this.resetEvent);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            if (this.expiredEventQueue != null) {
                this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
            }
            if (this.currentEventQueue != null) {
                this.currentEventQueue.restore((SnapshotStateList)state.get("CurrentEventQueue"));
            }
            this.resetEvent = (StreamEvent)state.get("ResetEvent");
        }

        @Override
        public boolean canDestroy() {
            return !(this.currentEventQueue != null && this.currentEventQueue.getFirst() != null || this.expiredEventQueue != null && this.expiredEventQueue.getFirst() != null || this.resetEvent != null);
        }
    }
}

