/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@Extension(name="max", namespace="", description="Returns the maximum value for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the maximum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the maximum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from fooStream#window.timeBatch(10 sec)\nselect max(temp) as maxTemp\ninsert into barStream;", description="max(temp) returns the maximum temp value recorded for all the events based on their arrival and expiry.")})
public class MaxAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<MaxAggregatorState> {
    private Attribute.Type returnType;

    @Override
    protected StateFactory<MaxAggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Max aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        boolean trackFutureStates = false;
        if (processingMode == ProcessingMode.SLIDE || outputExpectsExpiredEvents) {
            trackFutureStates = true;
        }
        this.returnType = attributeExpressionExecutors[0].getReturnType();
        boolean finalTrackFutureStates = trackFutureStates;
        return () -> {
            switch (this.returnType) {
                case FLOAT: {
                    return new MaxAttributeAggregatorStateFloat(finalTrackFutureStates);
                }
                case INT: {
                    return new MaxAttributeAggregatorStateInt(finalTrackFutureStates);
                }
                case LONG: {
                    return new MaxAttributeAggregatorStateLong(finalTrackFutureStates);
                }
                case DOUBLE: {
                    return new MaxAttributeAggregatorStateDouble(finalTrackFutureStates);
                }
            }
            throw new OperationNotSupportedException("Max not supported for " + this.returnType);
        };
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object processAdd(Object data, MaxAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data, MaxAggregatorState state) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, MaxAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data, MaxAggregatorState state) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(MaxAggregatorState state) {
        return state.reset();
    }

    abstract class MaxAggregatorState
    extends State {
        MaxAggregatorState() {
        }

        public abstract Object processAdd(Object var1);

        public abstract Object processRemove(Object var1);

        public abstract Object reset();

        protected abstract Object currentValue();
    }

    class MaxAttributeAggregatorStateLong
    extends MaxAggregatorState {
        private Deque<Long> maxDeque = null;
        private volatile Long maxValue = null;

        public MaxAttributeAggregatorStateLong(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Long>();
            }
        }

        @Override
        public Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.maxDeque != null) {
                Iterator<Long> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() < value) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.isEmpty()) && this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            state.put("MaxDeque", this.maxDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Long)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorStateInt
    extends MaxAggregatorState {
        private Deque<Integer> maxDeque = null;
        private volatile Integer maxValue = null;

        public MaxAttributeAggregatorStateInt(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Integer>();
            }
        }

        @Override
        public Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.maxDeque != null) {
                Iterator<Integer> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() < value) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.isEmpty()) && this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            state.put("MaxDeque", this.maxDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Integer)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorStateFloat
    extends MaxAggregatorState {
        private Deque<Float> maxDeque = null;
        private volatile Float maxValue = null;

        public MaxAttributeAggregatorStateFloat(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Float>();
            }
        }

        @Override
        public Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.maxDeque != null) {
                Iterator<Float> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next().floatValue() < value.floatValue()) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.isEmpty()) && this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            state.put("MaxDeque", this.maxDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Float)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorStateDouble
    extends MaxAggregatorState {
        private Deque<Double> maxDeque = null;
        private volatile Double maxValue = null;

        public MaxAttributeAggregatorStateDouble(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Double>();
            }
        }

        @Override
        public Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.maxDeque != null) {
                Iterator<Double> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() < value) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.isEmpty()) && this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            state.put("MaxDeque", this.maxDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Double)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }
}

