/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.input;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.DefinitionNotExistException;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.stream.input.InputDistributor;
import io.siddhi.core.stream.input.InputEntryValve;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.query.api.definition.AbstractDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class InputManager {
    private final InputEntryValve inputEntryValve;
    private final SiddhiAppContext siddhiAppContext;
    private Map<String, InputHandler> inputHandlerMap = new LinkedHashMap<String, InputHandler>();
    private Map<String, StreamJunction> streamJunctionMap;
    private InputDistributor inputDistributor;

    public InputManager(SiddhiAppContext siddhiAppContext, ConcurrentMap<String, AbstractDefinition> streamDefinitionMap, ConcurrentMap<String, StreamJunction> streamJunctionMap) {
        this.streamJunctionMap = streamJunctionMap;
        this.inputDistributor = new InputDistributor();
        this.inputEntryValve = new InputEntryValve(siddhiAppContext, this.inputDistributor);
        this.siddhiAppContext = siddhiAppContext;
    }

    public InputHandler getInputHandler(String streamId) {
        InputHandler inputHandler = this.inputHandlerMap.get(streamId);
        if (inputHandler == null) {
            return this.constructInputHandler(streamId);
        }
        return inputHandler;
    }

    public synchronized void disconnect() {
        for (InputHandler inputHandler : this.inputHandlerMap.values()) {
            inputHandler.disconnect();
        }
        this.inputHandlerMap.clear();
    }

    public InputHandler constructInputHandler(String streamId) {
        InputHandler inputHandler = new InputHandler(streamId, this.inputHandlerMap.size(), this.inputEntryValve, this.siddhiAppContext);
        StreamJunction streamJunction = this.streamJunctionMap.get(streamId);
        if (streamJunction == null) {
            throw new DefinitionNotExistException("Stream with stream ID " + streamId + " has not been defined");
        }
        this.inputDistributor.addInputProcessor(this.streamJunctionMap.get(streamId).constructPublisher());
        this.inputHandlerMap.put(streamId, inputHandler);
        return inputHandler;
    }
}

