/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.exception;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.exception.SiddhiAppContextException;
import io.siddhi.query.api.util.ExceptionUtil;

public class SiddhiAppCreationException
extends RuntimeException
implements SiddhiAppContextException {
    boolean classLoadingIssue = false;
    private String message;
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;
    private String siddhiAppName = null;
    private String siddhiAppPortion = null;

    public SiddhiAppCreationException(String message, boolean isClassLoadingIssue) {
        super(message);
        this.message = message;
        this.classLoadingIssue = isClassLoadingIssue;
    }

    public SiddhiAppCreationException(String message, Throwable throwable, boolean isClassLoadingIssue) {
        super(message, throwable);
        this.message = message;
        this.classLoadingIssue = isClassLoadingIssue;
    }

    public SiddhiAppCreationException(String message) {
        super(message);
        this.message = message;
    }

    public SiddhiAppCreationException(String message, Throwable throwable) {
        super(message, throwable);
        this.message = message;
    }

    public SiddhiAppCreationException(Throwable throwable) {
        super(throwable);
    }

    public SiddhiAppCreationException(String message, int[] queryContextStartIndex, int[] queryContextEndIndex, String siddhiAppName, String siddhiAppString) {
        super(message);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, siddhiAppName, siddhiAppString);
    }

    public SiddhiAppCreationException(String message, SiddhiElement siddhiElement, SiddhiAppContext siddhiAppContext) {
        super(message);
        this.message = message;
        this.setQueryContextIndexIfAbsent(siddhiElement.getQueryContextStartIndex(), siddhiElement.getQueryContextEndIndex(), siddhiAppContext.getName(), siddhiAppContext.getSiddhiAppString());
    }

    public SiddhiAppCreationException(String message, Throwable throwable, int[] queryContextStartIndex, int[] queryContextEndIndex) {
        super(message, throwable);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, this.siddhiAppName, null);
    }

    public SiddhiAppCreationException(String message, int[] queryContextStartIndex, int[] queryContextEndIndex) {
        super(message);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, this.siddhiAppName, null);
    }

    public SiddhiAppCreationException(String message, Throwable throwable, int[] queryContextStartIndex, int[] queryContextEndIndex, SiddhiAppContext siddhiAppContext) {
        super(message, throwable);
        this.message = message;
        if (siddhiAppContext != null) {
            this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, siddhiAppContext.getName(), siddhiAppContext.getSiddhiAppString());
        } else {
            this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, null, null);
        }
    }

    public SiddhiAppCreationException(String message, Throwable throwable, int[] queryContextStartIndex, int[] queryContextEndIndex, String siddhiAppName, String siddhiAppString) {
        super(message, throwable);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, siddhiAppName, siddhiAppString);
    }

    public boolean isClassLoadingIssue() {
        return this.classLoadingIssue;
    }

    public void setQueryContextIndexIfAbsent(int[] queryContextStartIndex, int[] queryContextEndIndex, String siddhiAppName, String siddhiAppString) {
        if (this.siddhiAppName == null) {
            this.siddhiAppName = siddhiAppName;
        }
        if (this.queryContextStartIndex == null && this.queryContextEndIndex == null && queryContextStartIndex != null && queryContextEndIndex != null) {
            this.queryContextStartIndex = queryContextStartIndex;
            this.queryContextEndIndex = queryContextEndIndex;
        }
        if (this.siddhiAppPortion == null && this.queryContextStartIndex != null && this.queryContextEndIndex != null && siddhiAppString != null) {
            this.siddhiAppPortion = ExceptionUtil.getContext((int[])this.queryContextStartIndex, (int[])this.queryContextEndIndex, (String)siddhiAppString);
        }
    }

    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    public String getMessageWithOutContext() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return ExceptionUtil.getMessageWithContext((String)this.siddhiAppName, (int[])this.queryContextStartIndex, (int[])this.queryContextEndIndex, (String)this.siddhiAppPortion, (String)this.message);
    }
}

