/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import org.apache.log4j.Logger;

public abstract class FunctionExecutor<S extends State>
implements ExpressionExecutor {
    private static final Logger log = Logger.getLogger(FunctionExecutor.class);
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected SiddhiQueryContext siddhiQueryContext;
    protected String functionId;
    protected ProcessingMode processingMode;
    private ConfigReader configReader;
    private int attributeSize;
    private StateHolder<S> stateHolder;

    public void initExecutor(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, ConfigReader configReader, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        this.processingMode = processingMode;
        this.configReader = configReader;
        this.siddhiQueryContext = siddhiQueryContext;
        try {
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            StateFactory<S> stateFactory = this.init(attributeExpressionExecutors, configReader, this.siddhiQueryContext);
            this.stateHolder = this.siddhiQueryContext.generateStateHolder(this.getClass().getName(), groupBy, stateFactory);
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t);
        }
    }

    protected abstract StateFactory<S> init(ExpressionExecutor[] var1, ConfigReader var2, SiddhiQueryContext var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(ComplexEvent event) {
        try {
            S state = this.stateHolder.getState();
            try {
                switch (this.attributeSize) {
                    case 0: {
                        Object object = this.execute((Object)null, state);
                        return object;
                    }
                    case 1: {
                        Object object = this.execute(this.attributeExpressionExecutors[0].execute(event), state);
                        return object;
                    }
                }
                Object[] data = new Object[this.attributeSize];
                for (int i = 0; i < this.attributeSize; ++i) {
                    data[i] = this.attributeExpressionExecutors[i].execute(event);
                }
                Object object = this.execute(data, state);
                return object;
            }
            finally {
                this.stateHolder.returnState(state);
            }
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException(e.getMessage() + ". Exception on class '" + this.getClass().getName() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(Object[] data) {
        S state = this.stateHolder.getState();
        try {
            Object object = this.execute(data, state);
            return object;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(Object data) {
        S state = this.stateHolder.getState();
        try {
            Object object = this.execute(data, state);
            return object;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    protected abstract Object execute(Object[] var1, S var2);

    protected abstract Object execute(Object var1, S var2);
}

