/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.SlidingFindableWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Extension(name="length", namespace="", description="A sliding length window that holds the last 'window.length' events at a given time, and gets updated for each arrival and expiry.", parameters={@Parameter(name="window.length", description="The number of events that should be included in a sliding length window.", type={DataType.INT})}, examples={@Example(syntax="define window StockEventWindow (symbol string, price float, volume int) length(10) output all events;\n\n@info(name = 'query0')\nfrom StockEventStream\ninsert into StockEventWindow;\n@info(name = 'query1')\n\nfrom StockEventWindow\nselect symbol, sum(price) as price\ninsert all events into outputStream ;", description="This will process last 10 events in a sliding manner.")})
public class LengthWindowProcessor
extends SlidingFindableWindowProcessor<WindowState> {
    private int length;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Length window should only have one parameter (<int> window.length), but found " + attributeExpressionExecutors.length + " input parameters.");
        }
        this.length = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
        return () -> new WindowState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        WindowState windowState = state;
        synchronized (windowState) {
            long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                if (state.count < this.length) {
                    state.count++;
                    state.expiredEventQueue.add(clonedEvent);
                    continue;
                }
                StreamEvent firstEvent = state.expiredEventQueue.poll();
                if (firstEvent != null) {
                    firstEvent.setTimestamp(currentTime);
                    streamEventChunk.insertBeforeCurrent(firstEvent);
                    state.expiredEventQueue.add(clonedEvent);
                    continue;
                }
                StreamEvent resetEvent = streamEventCloner.copyStreamEvent(streamEvent);
                resetEvent.setType(ComplexEvent.Type.RESET);
                streamEventChunk.insertAfterCurrent(resetEvent);
                streamEventChunk.insertAfterCurrent(clonedEvent);
                streamEventChunk.next();
                streamEventChunk.next();
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.expiredEventQueue, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.expiredEventQueue, streamEventCloner);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    static /* synthetic */ StreamEventClonerHolder access$200(LengthWindowProcessor x0) {
        return x0.streamEventClonerHolder;
    }

    static /* synthetic */ int access$300(LengthWindowProcessor x0) {
        return x0.length;
    }

    class WindowState
    extends State {
        private int count = 0;
        private SnapshotableStreamEventQueue expiredEventQueue = new SnapshotableStreamEventQueue(LengthWindowProcessor.access$200(LengthWindowProcessor.this), LengthWindowProcessor.access$300(LengthWindowProcessor.this));

        WindowState() {
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0 && this.expiredEventQueue.getFirst() == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Count", this.count);
            state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.count = (Integer)state.get("Count");
            this.expiredEventQueue.clear();
            this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
        }
    }
}

