/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator.incremental;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.CountIncrementalAttributeAggregator;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.SumIncrementalAttributeAggregator;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.Expression;

@Extension(name="avg", namespace="incrementalAggregator", description="Defines the logic to calculate the average, in incremental event processing", parameters={@Parameter(name="arg", description="The value that needs to be averaged incrementally, for different durations.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the calculated average value as a double.", type={DataType.DOUBLE})}, examples={@Example(syntax=" define aggregation cseEventAggregation\n from cseEventStream\n select avg(price) as avgPrice,\n aggregate by timeStamp every sec ... hour;", description="avg(price) returns the average price value for all the events based on their arrival and expiry. The average is calculated for sec, min and hour durations.")})
public class AvgIncrementalAttributeAggregator
extends IncrementalAttributeAggregator {
    private Attribute[] baseAttributes;
    private Expression[] baseAttributesInitialValues;

    @Override
    public void init(String attributeName, Attribute.Type attributeType) {
        if (attributeName == null) {
            throw new SiddhiAppCreationException("Average incremental attribute aggregation cannot be executed when no parameters are given");
        }
        SumIncrementalAttributeAggregator sumIncrementalAttributeAggregator = new SumIncrementalAttributeAggregator();
        sumIncrementalAttributeAggregator.init(attributeName, attributeType);
        CountIncrementalAttributeAggregator countIncrementalAttributeAggregator = new CountIncrementalAttributeAggregator();
        countIncrementalAttributeAggregator.init(attributeName, attributeType);
        Attribute sum = sumIncrementalAttributeAggregator.getBaseAttributes()[0];
        Attribute count = countIncrementalAttributeAggregator.getBaseAttributes()[0];
        Expression sumInitialValue = sumIncrementalAttributeAggregator.getBaseAttributeInitialValues()[0];
        Expression countInitialValue = countIncrementalAttributeAggregator.getBaseAttributeInitialValues()[0];
        this.baseAttributes = new Attribute[]{sum, count};
        this.baseAttributesInitialValues = new Expression[]{sumInitialValue, countInitialValue};
    }

    @Override
    public Expression aggregate() {
        return Expression.divide((Expression)Expression.variable((String)this.baseAttributes[0].getName()), (Expression)Expression.variable((String)this.baseAttributes[1].getName()));
    }

    @Override
    public Attribute[] getBaseAttributes() {
        return this.baseAttributes;
    }

    @Override
    public Expression[] getBaseAttributeInitialValues() {
        return this.baseAttributesInitialValues;
    }

    @Override
    public Expression[] getBaseAggregators() {
        Expression sumAggregator = Expression.function((String)"sum", (Expression[])new Expression[]{Expression.variable((String)this.getBaseAttributes()[0].getName())});
        Expression countAggregator = Expression.function((String)"sum", (Expression[])new Expression[]{Expression.variable((String)this.getBaseAttributes()[1].getName())});
        return new Expression[]{sumAggregator, countAggregator};
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }
}

