/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import io.siddhi.core.util.collection.expression.AndMultiPrimaryKeyCollectionExpression;
import io.siddhi.core.util.collection.expression.AttributeCollectionExpression;
import io.siddhi.core.util.collection.expression.CollectionExpression;
import io.siddhi.core.util.collection.expression.CompareCollectionExpression;
import io.siddhi.core.util.collection.operator.CollectionOperator;
import io.siddhi.core.util.collection.operator.EventChunkOperator;
import io.siddhi.core.util.collection.operator.IndexOperator;
import io.siddhi.core.util.collection.operator.MapOperator;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.collection.operator.OverwriteTableIndexOperator;
import io.siddhi.core.util.collection.operator.SnapshotableEventQueueOperator;
import io.siddhi.core.util.parser.CollectionExpressionParser;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OperatorParser {
    public static Operator constructOperator(Object storeEvents, Expression expression, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        if (storeEvents instanceof IndexedEventHolder) {
            CollectionExpression collectionExpression = CollectionExpressionParser.parseCollectionExpression(expression, matchingMetaInfoHolder, (IndexedEventHolder)storeEvents);
            CollectionExecutor collectionExecutor = CollectionExpressionParser.buildCollectionExecutor(collectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, true, ProcessingMode.BATCH, false, siddhiQueryContext);
            if (collectionExpression instanceof CompareCollectionExpression && ((CompareCollectionExpression)collectionExpression).getOperator() == Compare.Operator.EQUAL && (collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.INDEXED_RESULT_SET || collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET) && ((IndexedEventHolder)storeEvents).getPrimaryKeyReferenceHolders() != null && ((IndexedEventHolder)storeEvents).getPrimaryKeyReferenceHolders().length == 1 && ((IndexedEventHolder)storeEvents).getPrimaryKeyReferenceHolders()[0].getPrimaryKeyAttribute().equals(((AttributeCollectionExpression)((CompareCollectionExpression)collectionExpression).getAttributeCollectionExpression()).getAttribute())) {
                return new OverwriteTableIndexOperator(collectionExecutor, siddhiQueryContext.getName());
            }
            if (collectionExpression instanceof AndMultiPrimaryKeyCollectionExpression && collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET) {
                return new OverwriteTableIndexOperator(collectionExecutor, siddhiQueryContext.getName());
            }
            return new IndexOperator(collectionExecutor, siddhiQueryContext.getName());
        }
        if (storeEvents instanceof ComplexEventChunk) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            return new EventChunkOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        if (storeEvents instanceof SnapshotableStreamEventQueue) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            return new SnapshotableEventQueueOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        if (storeEvents instanceof Map) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            return new MapOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        if (storeEvents instanceof Collection) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            return new CollectionOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        throw new OperationNotSupportedException(storeEvents.getClass() + " is not supported by OperatorParser!");
    }

    private static boolean isTableIndexVariable(MatchingMetaInfoHolder matchingMetaInfoHolder, Expression expression, String indexAttribute) {
        MetaStreamEvent tableStreamEvent;
        Variable variable;
        return expression instanceof Variable && (variable = (Variable)expression).getStreamId() != null && (tableStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getStoreEventIndex())) != null && (tableStreamEvent.getInputReferenceId() != null && variable.getStreamId().equals(tableStreamEvent.getInputReferenceId()) || tableStreamEvent.getLastInputDefinition().getId().equals(variable.getStreamId())) && Arrays.asList(tableStreamEvent.getLastInputDefinition().getAttributeNameArray()).contains(indexAttribute);
    }
}

