/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="convert", namespace="", description="Converts the first input parameter according to the convertedTo parameter.", parameters={@Parameter(name="to.be.converted", description="This specifies the value to be converted.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL}), @Parameter(name="converted.to", description="A string constant parameter to which type the attribute need to be converted  using one of the following strings values: 'int', 'long', 'float', 'double', 'string', 'bool'.", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Based on the given convertedTo parameter.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL})}, examples={@Example(syntax="from fooStream\nselect convert(temp, 'double') as temp\ninsert into barStream;", description="This will convert fooStream temp value into 'double'."), @Example(syntax="from fooStream\nselect convert(temp, 'int') as temp\ninsert into barStream;", description="This will convert fooStream temp value into 'int' (value = \"convert(45.9, 'int') returns 46\").")})
public class ConvertFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType;
    private Attribute.Type inputType;

    public StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("convert() must have at 2 parameters, attribute and to be converted type");
        }
        this.inputType = attributeExpressionExecutors[0].getReturnType();
        if (this.inputType == Attribute.Type.OBJECT) {
            throw new SiddhiAppValidationException("1st parameter of convert() cannot be 'object' as it's not supported, it has to be either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found " + attributeExpressionExecutors[0].getReturnType());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("2nd parameter of convert() must be 'string' have constant value either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found " + attributeExpressionExecutors[0].getReturnType());
        }
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new SiddhiAppValidationException("2nd parameter of convert() must have constant value either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found a variable expression");
        }
        String type = (String)attributeExpressionExecutors[1].execute(null);
        if (Attribute.Type.STRING.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.STRING;
        } else if (Attribute.Type.BOOL.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.BOOL;
        } else if (Attribute.Type.DOUBLE.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.DOUBLE;
        } else if (Attribute.Type.FLOAT.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.FLOAT;
        } else if (Attribute.Type.INT.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.INT;
        } else if (Attribute.Type.LONG.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.LONG;
        } else {
            throw new SiddhiAppValidationException("2nd parameter of convert() must have value either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found '" + type + "'");
        }
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    protected Object execute(Object[] obj, State state) {
        Object data = obj[0];
        if (data != null) {
            try {
                switch (this.returnType) {
                    case STRING: {
                        return data.toString();
                    }
                    case INT: {
                        switch (this.inputType) {
                            case STRING: {
                                return Integer.parseInt((String)data);
                            }
                            case INT: {
                                return data;
                            }
                            case LONG: {
                                return ((Long)data).intValue();
                            }
                            case FLOAT: {
                                return ((Float)data).intValue();
                            }
                            case DOUBLE: {
                                return ((Double)data).intValue();
                            }
                            case BOOL: {
                                return (Boolean)data != false ? 1 : 0;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case LONG: {
                        switch (this.inputType) {
                            case STRING: {
                                return Long.parseLong((String)data);
                            }
                            case INT: {
                                return ((Integer)data).longValue();
                            }
                            case LONG: {
                                return data;
                            }
                            case FLOAT: {
                                return ((Float)data).longValue();
                            }
                            case DOUBLE: {
                                return ((Double)data).longValue();
                            }
                            case BOOL: {
                                return (Boolean)data != false ? 1L : 0L;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case FLOAT: {
                        switch (this.inputType) {
                            case STRING: {
                                return Float.valueOf(Float.parseFloat((String)data));
                            }
                            case INT: {
                                return Float.valueOf(((Integer)data).floatValue());
                            }
                            case LONG: {
                                return Float.valueOf(((Long)data).floatValue());
                            }
                            case FLOAT: {
                                return data;
                            }
                            case DOUBLE: {
                                return Float.valueOf(((Double)data).floatValue());
                            }
                            case BOOL: {
                                return Float.valueOf((Boolean)data != false ? 1.0f : 0.0f);
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case DOUBLE: {
                        switch (this.inputType) {
                            case STRING: {
                                return Double.parseDouble((String)data);
                            }
                            case INT: {
                                return ((Integer)data).doubleValue();
                            }
                            case LONG: {
                                return ((Long)data).doubleValue();
                            }
                            case FLOAT: {
                                return ((Float)data).doubleValue();
                            }
                            case DOUBLE: {
                                return data;
                            }
                            case BOOL: {
                                return (Boolean)data != false ? 1.0 : 0.0;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case BOOL: {
                        switch (this.inputType) {
                            case STRING: {
                                return Boolean.parseBoolean((String)data);
                            }
                            case INT: {
                                return (Integer)data == 1;
                            }
                            case LONG: {
                                return (Long)data == 1L;
                            }
                            case FLOAT: {
                                return ((Float)data).floatValue() == 1.0f;
                            }
                            case DOUBLE: {
                                return (Double)data == 1.0;
                            }
                            case BOOL: {
                                return data;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected Object execute(Object data, State state) {
        return null;
    }
}

