/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query;

import io.siddhi.core.event.Event;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.StoreQueryRuntimeException;
import io.siddhi.core.query.StoreQueryRuntime;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.query.api.definition.Attribute;
import java.util.ArrayList;
import java.util.List;

public class SelectStoreQueryRuntime
extends StoreQueryRuntime {
    private final CompiledSelection compiledSelection;
    private final CompiledCondition compiledCondition;
    private QueryableProcessor queryableProcessor;

    public SelectStoreQueryRuntime(QueryableProcessor queryableProcessor, CompiledCondition compiledCondition, CompiledSelection compiledSelection, List<Attribute> expectedOutputAttributeList, String queryName) {
        this.queryableProcessor = queryableProcessor;
        this.compiledCondition = compiledCondition;
        this.compiledSelection = compiledSelection;
        this.queryName = queryName;
        this.outputAttributes = expectedOutputAttributeList.toArray(new Attribute[expectedOutputAttributeList.size()]);
    }

    @Override
    public Event[] execute() {
        try {
            StreamEvent streamEvents;
            StateEvent stateEvent = new StateEvent(1, 0);
            if (streamEvents == null) {
                return null;
            }
            ArrayList<Event> events = new ArrayList<Event>();
            for (streamEvents = this.queryableProcessor.query(stateEvent, this.compiledCondition, this.compiledSelection, this.outputAttributes); streamEvents != null; streamEvents = streamEvents.getNext()) {
                events.add(new Event(streamEvents.getTimestamp(), streamEvents.getOutputData()));
            }
            return events.toArray(new Event[0]);
        }
        catch (Throwable t) {
            throw new StoreQueryRuntimeException("Error executing '" + this.queryName + "', " + t.getMessage(), t);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public StoreQueryRuntime.TYPE getType() {
        return StoreQueryRuntime.TYPE.SELECT;
    }
}

