/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.config;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiContext;
import io.siddhi.core.util.IdGenerator;
import io.siddhi.core.util.snapshot.SnapshotService;
import io.siddhi.core.util.snapshot.state.EmptyStateHolder;
import io.siddhi.core.util.snapshot.state.PartitionStateHolder;
import io.siddhi.core.util.snapshot.state.PartitionSyncStateHolder;
import io.siddhi.core.util.snapshot.state.SingleStateHolder;
import io.siddhi.core.util.snapshot.state.SingleSyncStateHolder;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import java.util.Map;

public class SiddhiQueryContext {
    private SiddhiAppContext siddhiAppContext = null;
    private String name;
    private String partitionId;
    private boolean partitioned;
    private OutputStream.OutputEventType outputEventType;
    private LatencyTracker latencyTracker;
    private Map<String, StateHolder> stateHolderMap;
    private IdGenerator idGenerator;

    public SiddhiQueryContext(SiddhiAppContext siddhiAppContext, String queryName) {
        this(siddhiAppContext, queryName, "null");
    }

    public SiddhiQueryContext(SiddhiAppContext siddhiAppContext, String queryName, String partitionId) {
        this.siddhiAppContext = siddhiAppContext;
        this.name = queryName;
        this.partitionId = partitionId;
        this.idGenerator = new IdGenerator();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SiddhiAppContext getSiddhiAppContext() {
        return this.siddhiAppContext;
    }

    public SiddhiContext getSiddhiContext() {
        return this.siddhiAppContext.getSiddhiContext();
    }

    public void setSiddhiAppContext(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
    }

    public void setOutputEventType(OutputStream.OutputEventType outputEventType) {
        this.outputEventType = outputEventType;
    }

    public OutputStream.OutputEventType getOutputEventType() {
        return this.outputEventType;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }

    public LatencyTracker getLatencyTracker() {
        return this.latencyTracker;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitionable) {
        this.partitioned = partitionable;
    }

    public String generateNewId() {
        return this.idGenerator.createNewId();
    }

    public StateHolder generateStateHolder(String name, boolean groupBy, StateFactory stateFactory) {
        return this.generateStateHolder(name, groupBy, stateFactory, false);
    }

    public StateHolder generateStateHolder(String name, boolean groupBy, StateFactory stateFactory, boolean unSafe) {
        if (stateFactory != null) {
            StateHolder stateHolder = unSafe ? (this.partitioned || groupBy ? new PartitionStateHolder(stateFactory) : new SingleStateHolder(stateFactory)) : (this.partitioned || groupBy ? new PartitionSyncStateHolder(stateFactory) : new SingleSyncStateHolder(stateFactory));
            if (SnapshotService.getSkipStateStorageThreadLocal().get() == null || !SnapshotService.getSkipStateStorageThreadLocal().get().booleanValue()) {
                this.stateHolderMap = this.siddhiAppContext.getSnapshotService().getStateHolderMap(this.partitionId, this.getName());
                this.stateHolderMap.put(this.idGenerator.createNewId() + "-" + name, stateHolder);
            }
            return stateHolder;
        }
        return new EmptyStateHolder();
    }
}

