/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.extension.holder.ExternalReferencedHolder;
import io.siddhi.core.util.extension.validator.InputParameterValidator;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractStreamProcessor<S extends State>
implements Processor,
ExternalReferencedHolder {
    private static final Logger log = Logger.getLogger(AbstractStreamProcessor.class);
    protected Processor nextProcessor;
    private List<Attribute> additionalAttributes;
    protected MetaStreamEvent metaStreamEvent;
    protected SiddhiQueryContext siddhiQueryContext;
    protected StreamEventClonerHolder streamEventClonerHolder = new StreamEventClonerHolder();
    protected AbstractDefinition inputDefinition;
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected int attributeExpressionLength;
    protected ComplexEventPopulater complexEventPopulater;
    protected StateHolder<S> stateHolder;

    public void initProcessor(MetaStreamEvent metaStreamEvent, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, boolean groupBy, SiddhiElement siddhiElement, SiddhiQueryContext siddhiQueryContext) {
        this.metaStreamEvent = metaStreamEvent;
        this.siddhiQueryContext = siddhiQueryContext;
        try {
            this.inputDefinition = metaStreamEvent.getLastInputDefinition();
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeExpressionLength = attributeExpressionExecutors.length;
            InputParameterValidator.validateExpressionExecutors(this, attributeExpressionExecutors);
            StateFactory<S> stateFactory = this.init(metaStreamEvent, metaStreamEvent.getLastInputDefinition(), attributeExpressionExecutors, configReader, this.streamEventClonerHolder, outputExpectsExpiredEvents, findToBeExecuted, siddhiQueryContext);
            this.additionalAttributes = this.getReturnAttributes();
            this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), groupBy, stateFactory);
            siddhiQueryContext.getSiddhiAppContext().addEternalReferencedHolder(this);
            if (this.additionalAttributes.size() > 0) {
                StreamDefinition outputDefinition = StreamDefinition.id((String)this.inputDefinition.getId());
                outputDefinition.setQueryContextStartIndex(siddhiElement.getQueryContextStartIndex());
                outputDefinition.setQueryContextEndIndex(siddhiElement.getQueryContextEndIndex());
                for (Attribute attribute : this.inputDefinition.getAttributeList()) {
                    outputDefinition.attribute(attribute.getName(), attribute.getType());
                }
                for (Attribute attribute : this.additionalAttributes) {
                    outputDefinition.attribute(attribute.getName(), attribute.getType());
                }
                metaStreamEvent.addInputDefinition((AbstractDefinition)outputDefinition);
            }
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t.getMessage(), t, siddhiElement.getQueryContextStartIndex(), siddhiElement.getQueryContextEndIndex(), siddhiQueryContext.getSiddhiAppContext());
        }
    }

    protected abstract StateFactory<S> init(MetaStreamEvent var1, AbstractDefinition var2, ExpressionExecutor[] var3, ConfigReader var4, StreamEventClonerHolder var5, boolean var6, boolean var7, SiddhiQueryContext var8);

    public abstract List<Attribute> getReturnAttributes();

    @Override
    public void process(ComplexEventChunk streamEventChunk) {
        streamEventChunk.reset();
        S state = this.stateHolder.getState();
        try {
            this.processEventChunk(streamEventChunk, this.nextProcessor, this.streamEventClonerHolder.getStreamEventCloner(), this.complexEventPopulater, state);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    protected abstract void processEventChunk(ComplexEventChunk<StreamEvent> var1, Processor var2, StreamEventCloner var3, ComplexEventPopulater var4, S var5);

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    public void constructStreamEventPopulater(MetaStreamEvent metaStreamEvent, int streamEventChainIndex) {
        if (this.complexEventPopulater == null) {
            this.complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamEvent, streamEventChainIndex, this.additionalAttributes);
        }
    }

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventClonerHolder.setStreamEventCloner(streamEventCloner);
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    public abstract ProcessingMode getProcessingMode();
}

