/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.input.source;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.stream.input.source.InputEventHandlerCallback;
import io.siddhi.core.stream.input.source.SourceSyncCallback;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.query.api.definition.StreamDefinition;

public abstract class SourceHandler<S extends State>
implements InputEventHandlerCallback {
    private InputHandler inputHandler;
    private StateHolder<S> stateHolder;
    private String id;

    final void initSourceHandler(String siddhiAppName, SourceSyncCallback sourceSyncCallback, StreamDefinition streamDefinition, SiddhiAppContext siddhiAppContext) {
        StateFactory stateFactory = this.init(siddhiAppName, sourceSyncCallback, streamDefinition, siddhiAppContext);
        this.id = siddhiAppName + "-" + streamDefinition.getId() + "-" + this.getClass().getName();
        this.stateHolder = siddhiAppContext.generateStateHolder(streamDefinition.getId() + "-" + this.getClass().getName(), stateFactory);
    }

    public abstract StateFactory init(String var1, SourceSyncCallback var2, StreamDefinition var3, SiddhiAppContext var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEvent(Event event, String[] transportSyncProperties) throws InterruptedException {
        S state = this.stateHolder.getState();
        try {
            this.sendEvent(event, transportSyncProperties, state, this.inputHandler);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEvents(Event[] events, String[] transportSyncProperties) throws InterruptedException {
        S state = this.stateHolder.getState();
        try {
            this.sendEvent(events, transportSyncProperties, state, this.inputHandler);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public abstract void sendEvent(Event var1, String[] var2, S var3, InputHandler var4) throws InterruptedException;

    public abstract void sendEvent(Event[] var1, String[] var2, S var3, InputHandler var4) throws InterruptedException;

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public String getId() {
        return this.id;
    }
}

