/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.stream.window.FindableProcessor;
import io.siddhi.core.table.CompiledUpdateSet;
import io.siddhi.core.table.record.RecordTableHandler;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.StringUtil;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.MemoryCalculable;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.core.util.transport.BackoffRetryCounter;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public abstract class Table
implements FindableProcessor,
MemoryCalculable {
    private static final Logger LOG = Logger.getLogger(Table.class);
    protected TableDefinition tableDefinition;
    private AtomicBoolean isTryingToConnect = new AtomicBoolean(false);
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService;
    protected SiddhiAppContext siddhiAppContext;
    private RecordTableHandler recordTableHandler;
    private LatencyTracker latencyTrackerFind;
    private LatencyTracker latencyTrackerInsert;
    private LatencyTracker latencyTrackerUpdate;
    private LatencyTracker latencyTrackerDelete;
    private LatencyTracker latencyTrackerUpdateOrInsert;
    private LatencyTracker latencyTrackerContains;
    private ThroughputTracker throughputTrackerFind;
    private ThroughputTracker throughputTrackerInsert;
    private ThroughputTracker throughputTrackerUpdate;
    private ThroughputTracker throughputTrackerDelete;
    private ThroughputTracker throughputTrackerUpdateOrInsert;
    private ThroughputTracker throughputTrackerContains;
    public Map<String, Table> tableMap;

    public void initTable(TableDefinition tableDefinition, StreamEventFactory storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler) {
        this.tableDefinition = tableDefinition;
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
        this.siddhiAppContext = siddhiAppContext;
        this.recordTableHandler = recordTableHandler;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.latencyTrackerFind = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "find");
            this.latencyTrackerInsert = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "insert");
            this.latencyTrackerUpdate = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "update");
            this.latencyTrackerDelete = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "delete");
            this.latencyTrackerUpdateOrInsert = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "updateOrInsert");
            this.latencyTrackerContains = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "contains");
            this.throughputTrackerFind = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "find");
            this.throughputTrackerInsert = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "insert");
            this.throughputTrackerUpdate = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "update");
            this.throughputTrackerDelete = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "delete");
            this.throughputTrackerUpdateOrInsert = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "updateOrInsert");
            this.throughputTrackerContains = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "contains");
        }
        this.init(tableDefinition, storeEventPool, storeEventCloner, configReader, siddhiAppContext, recordTableHandler);
    }

    protected abstract void init(TableDefinition var1, StreamEventFactory var2, StreamEventCloner var3, ConfigReader var4, SiddhiAppContext var5, RecordTableHandler var6);

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEvents(ComplexEventChunk<StreamEvent> addingEventChunk, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerInsert.markIn();
                }
                addingEventChunk.reset();
                this.add(addingEventChunk);
                if (this.throughputTrackerInsert == null || Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) > 0) return;
                this.throughputTrackerInsert.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.addEvents(addingEventChunk, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerInsert.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.warn((Object)("Error on '" + this.siddhiAppContext.getName() + "' while performing add for events '" + addingEventChunk + "', operation busy waiting at Table '" + this.tableDefinition.getId() + "' as its trying to reconnect!"));
            this.waitWhileConnect();
            LOG.info((Object)("SiddhiApp '" + this.siddhiAppContext.getName() + "' table '" + this.tableDefinition.getId() + "' has become available for add operation for events '" + addingEventChunk + "'"));
            this.addEvents(addingEventChunk, noOfEvents);
            return;
        } else {
            this.connectWithRetry();
            this.addEvents(addingEventChunk, noOfEvents);
        }
    }

    protected abstract void add(ComplexEventChunk<StreamEvent> var1) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerFind != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerFind.markIn();
                }
                StreamEvent results = this.find(compiledCondition, matchingEvent);
                if (this.throughputTrackerFind != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.throughputTrackerFind.eventIn();
                }
                StreamEvent streamEvent = results;
                return streamEvent;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                StreamEvent streamEvent = this.find(matchingEvent, compiledCondition);
                return streamEvent;
            }
            finally {
                if (this.latencyTrackerFind != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerFind.markOut();
                }
            }
        }
        if (this.isTryingToConnect.get()) {
            LOG.warn((Object)("Error on '" + this.siddhiAppContext.getName() + "' while performing find for events '" + matchingEvent + "', operation busy waiting at Table '" + this.tableDefinition.getId() + "' as its trying to reconnect!"));
            this.waitWhileConnect();
            LOG.info((Object)("SiddhiApp '" + this.siddhiAppContext.getName() + "' table '" + this.tableDefinition.getId() + "' has become available for find operation for events '" + matchingEvent + "'"));
            return this.find(matchingEvent, compiledCondition);
        }
        this.connectWithRetry();
        return this.find(matchingEvent, compiledCondition);
    }

    protected abstract StreamEvent find(CompiledCondition var1, StateEvent var2) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteEvents(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerDelete != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerDelete.markIn();
                }
                this.delete(deletingEventChunk, compiledCondition);
                if (this.throughputTrackerDelete == null || Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) > 0) return;
                this.throughputTrackerDelete.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.deleteEvents(deletingEventChunk, compiledCondition, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerDelete != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerDelete.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.warn((Object)("Error on '" + this.siddhiAppContext.getName() + "' while performing delete for events '" + deletingEventChunk + "', operation busy waiting at Table '" + this.tableDefinition.getId() + "' as its trying to reconnect!"));
            this.waitWhileConnect();
            LOG.info((Object)("SiddhiApp '" + this.siddhiAppContext.getName() + "' table '" + this.tableDefinition.getId() + "' has become available for delete operation for events '" + deletingEventChunk + "'"));
            this.deleteEvents(deletingEventChunk, compiledCondition, noOfEvents);
            return;
        } else {
            this.connectWithRetry();
            this.deleteEvents(deletingEventChunk, compiledCondition, noOfEvents);
        }
    }

    protected abstract void delete(ComplexEventChunk<StateEvent> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateEvents(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerUpdate != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerUpdate.markIn();
                }
                this.update(updatingEventChunk, compiledCondition, compiledUpdateSet);
                if (this.throughputTrackerUpdate == null || Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) > 0) return;
                this.throughputTrackerUpdate.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.updateEvents(updatingEventChunk, compiledCondition, compiledUpdateSet, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerUpdate != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerUpdate.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.warn((Object)("Error on '" + this.siddhiAppContext.getName() + "' while performing update for events '" + updatingEventChunk + "', operation busy waiting at Table '" + this.tableDefinition.getId() + "' as its trying to reconnect!"));
            this.waitWhileConnect();
            LOG.info((Object)("SiddhiApp '" + this.siddhiAppContext.getName() + "' table '" + this.tableDefinition.getId() + "' has become available for update operation for events '" + updatingEventChunk + "'"));
            this.updateEvents(updatingEventChunk, compiledCondition, compiledUpdateSet, noOfEvents);
            return;
        } else {
            this.connectWithRetry();
            this.updateEvents(updatingEventChunk, compiledCondition, compiledUpdateSet, noOfEvents);
        }
    }

    protected abstract void update(ComplexEventChunk<StateEvent> var1, CompiledCondition var2, CompiledUpdateSet var3) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateOrAddEvents(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerUpdateOrInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerUpdateOrInsert.markIn();
                }
                this.updateOrAdd(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor);
                if (this.throughputTrackerUpdateOrInsert == null || Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) > 0) return;
                this.throughputTrackerUpdateOrInsert.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.updateOrAddEvents(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerUpdateOrInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerUpdateOrInsert.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.warn((Object)("Error on '" + this.siddhiAppContext.getName() + "' while performing upsert for events '" + updateOrAddingEventChunk + "', operation busy waiting at Table '" + this.tableDefinition.getId() + "' as its trying to reconnect!"));
            this.waitWhileConnect();
            LOG.info((Object)("SiddhiApp '" + this.siddhiAppContext.getName() + "' table '" + this.tableDefinition.getId() + "' has become available for upsert operation for events '" + updateOrAddingEventChunk + "'"));
            this.updateOrAddEvents(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor, noOfEvents);
            return;
        } else {
            this.connectWithRetry();
            this.updateOrAddEvents(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor, noOfEvents);
        }
    }

    protected abstract void updateOrAdd(ComplexEventChunk<StateEvent> var1, CompiledCondition var2, CompiledUpdateSet var3, AddingStreamEventExtractor var4) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEvent(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerContains != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerContains.markIn();
                }
                boolean results = this.contains(matchingEvent, compiledCondition);
                if (this.throughputTrackerContains != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.throughputTrackerContains.eventIn();
                }
                boolean bl = results;
                return bl;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                boolean bl = this.containsEvent(matchingEvent, compiledCondition);
                return bl;
            }
            finally {
                if (this.latencyTrackerContains != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerContains.markOut();
                }
            }
        }
        if (this.isTryingToConnect.get()) {
            LOG.warn((Object)("Error on '" + this.siddhiAppContext.getName() + "' while performing contains check for event '" + matchingEvent + "', operation busy waiting at Table '" + this.tableDefinition.getId() + "' as its trying to reconnect!"));
            this.waitWhileConnect();
            LOG.info((Object)("SiddhiApp '" + this.siddhiAppContext.getName() + "' table '" + this.tableDefinition.getId() + "' has become available for contains check operation for matching event '" + matchingEvent + "'"));
            return this.containsEvent(matchingEvent, compiledCondition);
        }
        this.connectWithRetry();
        return this.containsEvent(matchingEvent, compiledCondition);
    }

    protected abstract boolean contains(StateEvent var1, CompiledCondition var2) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectWithRetry() {
        if (!this.isConnected.get()) {
            this.isTryingToConnect.set(true);
            try {
                this.connectAndLoadCache();
                this.isConnected.set(true);
                Table table = this;
                synchronized (table) {
                    this.isTryingToConnect.set(false);
                    this.notifyAll();
                }
                this.backoffRetryCounter.reset();
            }
            catch (ConnectionUnavailableException e) {
                LOG.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext)) + " Error while connecting to Table '" + StringUtil.removeCRLFCharacters(this.tableDefinition.getId()) + "', will retry in '" + StringUtil.removeCRLFCharacters(this.backoffRetryCounter.getTimeInterval()) + "'."), (Throwable)e);
                this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Table.this.connectWithRetry();
                    }
                }, this.backoffRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
                this.backoffRetryCounter.increment();
            }
            catch (RuntimeException e) {
                LOG.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext)) + " . Error while connecting to Table '" + StringUtil.removeCRLFCharacters(this.tableDefinition.getId()) + "'."), (Throwable)e);
                throw e;
            }
        }
    }

    public void setIsConnectedToFalse() {
        this.isConnected.set(false);
    }

    public boolean getIsTryingToConnect() {
        return this.isTryingToConnect.get();
    }

    public boolean getIsConnected() {
        return this.isConnected.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitWhileConnect() {
        try {
            Table table = this;
            synchronized (table) {
                while (this.isTryingToConnect.get()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error on SiddhiApp '" + this.siddhiAppContext.getName() + "', interrupted while busy wait on connection retrying condition " + e.getMessage(), e);
        }
    }

    public abstract CompiledUpdateSet compileUpdateSet(UpdateSet var1, MatchingMetaInfoHolder var2, List<VariableExpressionExecutor> var3, Map<String, Table> var4, SiddhiQueryContext var5);

    protected abstract void connectAndLoadCache() throws ConnectionUnavailableException;

    protected abstract void disconnect();

    protected abstract void destroy();

    public RecordTableHandler getHandler() {
        return this.recordTableHandler;
    }

    public void shutdown() {
        this.disconnect();
        this.destroy();
        this.isConnected.set(false);
        this.isTryingToConnect.set(false);
    }
}

