/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.input.ProcessStreamReceiver;
import io.siddhi.core.query.input.stream.single.EntryValveProcessor;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.SchedulingProcessor;
import io.siddhi.core.query.processor.filter.FilterProcessor;
import io.siddhi.core.query.processor.stream.AbstractStreamProcessor;
import io.siddhi.core.query.processor.stream.StreamProcessor;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.query.processor.stream.window.WindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.SiddhiClassLoader;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.extension.holder.StreamFunctionProcessorExtensionHolder;
import io.siddhi.core.util.extension.holder.StreamProcessorExtensionHolder;
import io.siddhi.core.util.extension.holder.WindowProcessorExtensionHolder;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.execution.query.input.handler.Filter;
import io.siddhi.query.api.execution.query.input.handler.StreamFunction;
import io.siddhi.query.api.execution.query.input.handler.StreamHandler;
import io.siddhi.query.api.execution.query.input.handler.Window;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.extension.Extension;
import java.util.List;
import java.util.Map;

public class SingleInputStreamParser {
    public static SingleStreamRuntime parseInputStream(SingleInputStream inputStream, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, Map<String, Table> tableMap, MetaComplexEvent metaComplexEvent, ProcessStreamReceiver processStreamReceiver, boolean supportsBatchProcessing, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        MetaStreamEvent metaStreamEvent;
        Processor processor = null;
        EntryValveProcessor entryValveProcessor = null;
        ProcessingMode processingMode = ProcessingMode.BATCH;
        boolean first = true;
        if (metaComplexEvent instanceof MetaStateEvent) {
            metaStreamEvent = new MetaStreamEvent();
            ((MetaStateEvent)metaComplexEvent).addEvent(metaStreamEvent);
            SingleInputStreamParser.initMetaStreamEvent(inputStream, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, metaStreamEvent);
        } else {
            metaStreamEvent = (MetaStreamEvent)metaComplexEvent;
            SingleInputStreamParser.initMetaStreamEvent(inputStream, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, metaStreamEvent);
        }
        if (!inputStream.getStreamHandlers().isEmpty() && windowDefinitionMap != null && windowDefinitionMap.containsKey(inputStream.getStreamId())) {
            for (StreamHandler handler : inputStream.getStreamHandlers()) {
                if (!(handler instanceof Window)) continue;
                throw new OperationNotSupportedException("Cannot create " + ((Window)handler).getName() + " window for the window stream " + inputStream.getStreamId());
            }
        }
        if (!inputStream.getStreamHandlers().isEmpty()) {
            for (StreamHandler handler : inputStream.getStreamHandlers()) {
                Processor currentProcessor = SingleInputStreamParser.generateProcessor(handler, metaComplexEvent, variableExpressionExecutors, tableMap, supportsBatchProcessing, outputExpectsExpiredEvents, findToBeExecuted, siddhiQueryContext);
                if (currentProcessor instanceof SchedulingProcessor) {
                    if (entryValveProcessor == null) {
                        entryValveProcessor = new EntryValveProcessor(siddhiQueryContext.getSiddhiAppContext());
                        if (first) {
                            processor = entryValveProcessor;
                            first = false;
                        } else {
                            processor.setToLast(entryValveProcessor);
                        }
                    }
                    Scheduler scheduler = SchedulerParser.parse(entryValveProcessor, siddhiQueryContext);
                    ((SchedulingProcessor)currentProcessor).setScheduler(scheduler);
                }
                if (currentProcessor instanceof AbstractStreamProcessor) {
                    processingMode = ProcessingMode.findUpdatedProcessingMode(processingMode, ((AbstractStreamProcessor)currentProcessor).getProcessingMode());
                }
                if (first) {
                    processor = currentProcessor;
                    first = false;
                    continue;
                }
                processor.setToLast(currentProcessor);
            }
        }
        metaStreamEvent.initializeAfterWindowData();
        return new SingleStreamRuntime(processStreamReceiver, processor, processingMode, metaComplexEvent);
    }

    public static Processor generateProcessor(StreamHandler streamHandler, MetaComplexEvent metaEvent, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, boolean supportsBatchProcessing, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor[] attributeExpressionExecutors;
        MetaStreamEvent metaStreamEvent;
        Expression[] parameters = streamHandler.getParameters();
        int stateIndex = -1;
        if (metaEvent instanceof MetaStateEvent) {
            stateIndex = ((MetaStateEvent)metaEvent).getStreamEventCount() - 1;
            metaStreamEvent = ((MetaStateEvent)metaEvent).getMetaStreamEvent(stateIndex);
        } else {
            metaStreamEvent = (MetaStreamEvent)metaEvent;
        }
        if (parameters != null) {
            if (parameters.length > 0) {
                attributeExpressionExecutors = new ExpressionExecutor[parameters.length];
                int parametersLength = parameters.length;
                for (int i = 0; i < parametersLength; ++i) {
                    attributeExpressionExecutors[i] = ExpressionParser.parseExpression(parameters[i], metaEvent, stateIndex, tableMap, variableExpressionExecutors, false, -1, ProcessingMode.BATCH, false, siddhiQueryContext);
                }
            } else {
                List attributeList = metaStreamEvent.getLastInputDefinition().getAttributeList();
                int parameterSize = attributeList.size();
                attributeExpressionExecutors = new ExpressionExecutor[parameterSize];
                for (int i = 0; i < parameterSize; ++i) {
                    attributeExpressionExecutors[i] = ExpressionParser.parseExpression((Expression)new Variable(((Attribute)attributeList.get(i)).getName()), metaEvent, stateIndex, tableMap, variableExpressionExecutors, false, -1, ProcessingMode.BATCH, false, siddhiQueryContext);
                }
            }
        } else {
            attributeExpressionExecutors = new ExpressionExecutor[]{};
        }
        if (streamHandler instanceof Filter) {
            return new FilterProcessor(attributeExpressionExecutors[0]);
        }
        if (streamHandler instanceof Window) {
            WindowProcessor windowProcessor = (WindowProcessor)SiddhiClassLoader.loadExtensionImplementation((Extension)streamHandler, WindowProcessorExtensionHolder.getInstance(siddhiQueryContext.getSiddhiAppContext()));
            ConfigReader configReader = siddhiQueryContext.getSiddhiContext().getConfigManager().generateConfigReader(((Window)streamHandler).getNamespace(), ((Window)streamHandler).getName());
            windowProcessor.initProcessor(metaStreamEvent, attributeExpressionExecutors, configReader, outputExpectsExpiredEvents, findToBeExecuted, false, (SiddhiElement)streamHandler, siddhiQueryContext);
            return windowProcessor;
        }
        if (streamHandler instanceof StreamFunction) {
            ConfigReader configReader;
            block14: {
                configReader = siddhiQueryContext.getSiddhiContext().getConfigManager().generateConfigReader(((StreamFunction)streamHandler).getNamespace(), ((StreamFunction)streamHandler).getName());
                if (supportsBatchProcessing) {
                    try {
                        StreamProcessor abstractStreamProcessor = (StreamProcessor)SiddhiClassLoader.loadExtensionImplementation((Extension)streamHandler, StreamProcessorExtensionHolder.getInstance(siddhiQueryContext.getSiddhiAppContext()));
                        abstractStreamProcessor.initProcessor(metaStreamEvent, attributeExpressionExecutors, configReader, outputExpectsExpiredEvents, false, false, (SiddhiElement)streamHandler, siddhiQueryContext);
                        return abstractStreamProcessor;
                    }
                    catch (SiddhiAppCreationException e) {
                        if (e.isClassLoadingIssue()) break block14;
                        ExceptionUtil.populateQueryContext(e, (SiddhiElement)streamHandler, siddhiQueryContext.getSiddhiAppContext());
                        throw e;
                    }
                }
            }
            StreamFunctionProcessor abstractStreamProcessor = (StreamFunctionProcessor)SiddhiClassLoader.loadExtensionImplementation((Extension)streamHandler, StreamFunctionProcessorExtensionHolder.getInstance(siddhiQueryContext.getSiddhiAppContext()));
            abstractStreamProcessor.initProcessor(metaStreamEvent, attributeExpressionExecutors, configReader, outputExpectsExpiredEvents, false, false, (SiddhiElement)streamHandler, siddhiQueryContext);
            return abstractStreamProcessor;
        }
        throw new SiddhiAppCreationException(streamHandler.getClass().getName() + " is not supported", streamHandler.getQueryContextStartIndex(), streamHandler.getQueryContextEndIndex());
    }

    private static void initMetaStreamEvent(SingleInputStream inputStream, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, MetaStreamEvent metaStreamEvent) {
        String streamId = inputStream.getStreamId();
        if (!inputStream.isInnerStream() && windowDefinitionMap != null && windowDefinitionMap.containsKey(streamId)) {
            AbstractDefinition inputDefinition = windowDefinitionMap.get(streamId);
            if (!metaStreamEvent.getInputDefinitions().contains(inputDefinition)) {
                metaStreamEvent.addInputDefinition(inputDefinition);
            }
        } else if (streamDefinitionMap != null && streamDefinitionMap.containsKey(streamId)) {
            AbstractDefinition inputDefinition = streamDefinitionMap.get(streamId);
            metaStreamEvent.addInputDefinition(inputDefinition);
        } else if (!inputStream.isInnerStream() && tableDefinitionMap != null && tableDefinitionMap.containsKey(streamId)) {
            AbstractDefinition inputDefinition = tableDefinitionMap.get(streamId);
            metaStreamEvent.addInputDefinition(inputDefinition);
        } else if (!inputStream.isInnerStream() && aggregationDefinitionMap != null && aggregationDefinitionMap.containsKey(streamId)) {
            AbstractDefinition inputDefinition = aggregationDefinitionMap.get(streamId);
            metaStreamEvent.addInputDefinition(inputDefinition);
        } else {
            throw new SiddhiAppCreationException("Stream/table/window/aggregation definition with ID '" + inputStream.getStreamId() + "' has not been defined", inputStream.getQueryContextStartIndex(), inputStream.getQueryContextEndIndex());
        }
        if (inputStream.getStreamReferenceId() != null && !inputStream.getStreamId().equals(inputStream.getStreamReferenceId())) {
            metaStreamEvent.setInputReferenceId(inputStream.getStreamReferenceId());
        }
    }
}

