/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.persistence.util;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.PersistenceStoreException;
import io.siddhi.core.util.persistence.util.IncrementalSnapshotInfo;
import io.siddhi.core.util.snapshot.AsyncIncrementalSnapshotPersistor;
import io.siddhi.core.util.snapshot.AsyncSnapshotPersistor;
import io.siddhi.core.util.snapshot.IncrementalSnapshot;
import io.siddhi.core.util.snapshot.PersistenceReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;

public final class PersistenceHelper {
    public static IncrementalSnapshotInfo convertRevision(String revision) {
        String[] items = revision.split("__");
        if (items.length == 7) {
            return new IncrementalSnapshotInfo(items[1], items[2], items[4], items[5], Long.parseLong(items[0]), IncrementalSnapshotInfo.SnapshotType.valueOf(items[6]), items[3]);
        }
        if (items.length == 4) {
            return new IncrementalSnapshotInfo(items[1], items[2], null, null, Long.parseLong(items[0]), IncrementalSnapshotInfo.SnapshotType.PERIODIC, items[3]);
        }
        throw new PersistenceStoreException("Invalid revision found '" + revision + "'!");
    }

    public static PersistenceReference persist(byte[] serializeObj, SiddhiAppContext siddhiAppContext) {
        long revisionTime = System.currentTimeMillis();
        AsyncSnapshotPersistor asyncSnapshotPersistor = new AsyncSnapshotPersistor(serializeObj, siddhiAppContext.getSiddhiContext().getPersistenceStore(), siddhiAppContext.getName(), revisionTime);
        Future<?> future = siddhiAppContext.getExecutorService().submit(asyncSnapshotPersistor);
        return new PersistenceReference(future, asyncSnapshotPersistor.getRevision());
    }

    public static PersistenceReference persist(IncrementalSnapshot serializeObj, SiddhiAppContext siddhiAppContext) {
        Map<String, Map<String, byte[]>> incrementalState;
        Map<String, Map<String, byte[]>> incrementalStateBase;
        long revisionTime = System.currentTimeMillis();
        ArrayList<Future> incrementalFutures = new ArrayList<Future>();
        Map<String, Map<String, byte[]>> periodicStateBase = serializeObj.getPeriodicState();
        if (periodicStateBase != null) {
            periodicStateBase.forEach((partitionId, value) -> value.forEach((id, value1) -> {
                String[] items = id.split("__");
                AsyncIncrementalSnapshotPersistor asyncIncrementSnapshotPersistor = new AsyncIncrementalSnapshotPersistor((byte[])value1, siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore(), new IncrementalSnapshotInfo(siddhiAppContext.getName(), (String)partitionId, items[1], items[2], revisionTime, IncrementalSnapshotInfo.SnapshotType.PERIODIC, items[0]));
                Future<?> future = siddhiAppContext.getExecutorService().submit(asyncIncrementSnapshotPersistor);
                incrementalFutures.add(future);
            }));
        }
        if ((incrementalStateBase = serializeObj.getIncrementalStateBase()) != null) {
            incrementalStateBase.forEach((partitionId, value) -> value.forEach((id, value1) -> {
                String[] items = id.split("__");
                AsyncIncrementalSnapshotPersistor asyncIncrementSnapshotPersistor = new AsyncIncrementalSnapshotPersistor((byte[])value1, siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore(), new IncrementalSnapshotInfo(siddhiAppContext.getName(), (String)partitionId, items[1], items[2], revisionTime, IncrementalSnapshotInfo.SnapshotType.BASE, items[0]));
                Future<?> future = siddhiAppContext.getExecutorService().submit(asyncIncrementSnapshotPersistor);
                incrementalFutures.add(future);
            }));
        }
        if ((incrementalState = serializeObj.getIncrementalState()) != null) {
            incrementalState.forEach((partitionId, value) -> value.forEach((id, value1) -> {
                String[] items = id.split("__");
                AsyncIncrementalSnapshotPersistor asyncIncrementSnapshotPersistor = new AsyncIncrementalSnapshotPersistor((byte[])value1, siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore(), new IncrementalSnapshotInfo(siddhiAppContext.getName(), (String)partitionId, items[1], items[2], revisionTime, IncrementalSnapshotInfo.SnapshotType.INCREMENT, items[0]));
                Future<?> future = siddhiAppContext.getExecutorService().submit(asyncIncrementSnapshotPersistor);
                incrementalFutures.add(future);
            }));
        }
        return new PersistenceReference(incrementalFutures, revisionTime + "__" + siddhiAppContext.getName());
    }
}

