/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.window;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.input.stream.single.EntryValveProcessor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.SchedulingProcessor;
import io.siddhi.core.query.processor.stream.window.FindableProcessor;
import io.siddhi.core.query.processor.stream.window.WindowProcessor;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.parser.SingleInputStreamParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.MemoryCalculable;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.execution.query.input.handler.StreamHandler;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.expression.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class Window
implements FindableProcessor,
MemoryCalculable {
    private final WindowDefinition windowDefinition;
    private final SiddhiAppContext siddhiAppContext;
    private final LockWrapper lockWrapper;
    private final ZeroStreamEventConverter eventConverter = new ZeroStreamEventConverter();
    private StreamJunction.Publisher outputPublisher;
    private Processor windowProcessor;
    private WindowProcessor internalWindowProcessor;
    private StreamEventFactory streamEventFactory;
    private LatencyTracker latencyTrackerInsert;
    private LatencyTracker latencyTrackerFind;
    private ThroughputTracker throughputTrackerFind;
    private ThroughputTracker throughputTrackerInsert;

    public Window(WindowDefinition windowDefinition, SiddhiAppContext siddhiAppContext) {
        this.windowDefinition = windowDefinition;
        this.siddhiAppContext = siddhiAppContext;
        this.lockWrapper = new LockWrapper(windowDefinition.getId());
        this.lockWrapper.setLock(new ReentrantLock());
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.latencyTrackerFind = QueryParserHelper.createLatencyTracker(siddhiAppContext, windowDefinition.getId(), "Windows", "find");
            this.latencyTrackerInsert = QueryParserHelper.createLatencyTracker(siddhiAppContext, windowDefinition.getId(), "Windows", "insert");
            this.throughputTrackerFind = QueryParserHelper.createThroughputTracker(siddhiAppContext, windowDefinition.getId(), "Windows", "find");
            this.throughputTrackerInsert = QueryParserHelper.createThroughputTracker(siddhiAppContext, windowDefinition.getId(), "Windows", "insert");
        }
    }

    public void init(Map<String, Table> tableMap, Map<String, Window> eventWindowMap, String windowName, boolean findToBeExecuted) {
        if (this.windowProcessor != null) {
            return;
        }
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        metaStreamEvent.addInputDefinition((AbstractDefinition)this.windowDefinition);
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
        metaStreamEvent.initializeAfterWindowData();
        for (Attribute attribute : this.windowDefinition.getAttributeList()) {
            metaStreamEvent.addOutputData(attribute);
        }
        this.streamEventFactory = new StreamEventFactory(metaStreamEvent);
        StreamEventCloner streamEventCloner = new StreamEventCloner(metaStreamEvent, this.streamEventFactory);
        OutputStream.OutputEventType outputEventType = this.windowDefinition.getOutputEventType();
        boolean outputExpectsExpiredEvents = outputEventType != OutputStream.OutputEventType.CURRENT_EVENTS;
        SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(this.siddhiAppContext, windowName);
        WindowProcessor internalWindowProcessor = (WindowProcessor)SingleInputStreamParser.generateProcessor((StreamHandler)this.windowDefinition.getWindow(), metaStreamEvent, new ArrayList<VariableExpressionExecutor>(), tableMap, false, outputExpectsExpiredEvents, findToBeExecuted, siddhiQueryContext);
        internalWindowProcessor.setStreamEventCloner(streamEventCloner);
        internalWindowProcessor.constructStreamEventPopulater(metaStreamEvent, 0);
        EntryValveProcessor entryValveProcessor = null;
        if (internalWindowProcessor instanceof SchedulingProcessor) {
            entryValveProcessor = new EntryValveProcessor(this.siddhiAppContext);
            Scheduler scheduler = SchedulerParser.parse(entryValveProcessor, siddhiQueryContext);
            scheduler.init(this.lockWrapper, windowName);
            scheduler.setStreamEventFactory(this.streamEventFactory);
            ((SchedulingProcessor)((Object)internalWindowProcessor)).setScheduler(scheduler);
        }
        if (entryValveProcessor != null) {
            entryValveProcessor.setToLast(internalWindowProcessor);
            this.windowProcessor = entryValveProcessor;
        } else {
            this.windowProcessor = internalWindowProcessor;
        }
        this.windowProcessor.setToLast(new StreamPublishProcessor(outputEventType));
        this.internalWindowProcessor = internalWindowProcessor;
    }

    public void setPublisher(StreamJunction.Publisher publisher) {
        this.outputPublisher = publisher;
    }

    public WindowDefinition getWindowDefinition() {
        return this.windowDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ComplexEventChunk complexEventChunk) {
        try {
            this.lockWrapper.lock();
            complexEventChunk.reset();
            Object complexEvents = complexEventChunk.getFirst();
            StreamEvent firstEvent = this.streamEventFactory.newInstance();
            this.eventConverter.convertComplexEvent((ComplexEvent)complexEvents, firstEvent);
            StreamEvent currentEvent = firstEvent;
            int numberOfEvents = 0;
            for (complexEvents = complexEvents.getNext(); complexEvents != null; complexEvents = complexEvents.getNext()) {
                ++numberOfEvents;
                StreamEvent nextEvent = this.streamEventFactory.newInstance();
                this.eventConverter.convertComplexEvent((ComplexEvent)complexEvents, nextEvent);
                currentEvent.setNext(nextEvent);
                currentEvent = nextEvent;
            }
            try {
                if (this.throughputTrackerInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.throughputTrackerInsert.eventsIn(numberOfEvents);
                    this.latencyTrackerInsert.markIn();
                }
                this.windowProcessor.process(new ComplexEventChunk<StreamEvent>(firstEvent, currentEvent, complexEventChunk.isBatch()));
            }
            finally {
                if (this.throughputTrackerInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                    this.latencyTrackerInsert.markOut();
                }
            }
        }
        finally {
            this.lockWrapper.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        try {
            if (this.throughputTrackerFind != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                this.throughputTrackerFind.eventIn();
                this.latencyTrackerFind.markIn();
            }
            StreamEvent streamEvent = ((FindableProcessor)((Object)this.internalWindowProcessor)).find(matchingEvent, compiledCondition);
            return streamEvent;
        }
        finally {
            if (this.throughputTrackerFind != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                this.latencyTrackerFind.markOut();
            }
        }
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        if (this.internalWindowProcessor instanceof FindableProcessor) {
            return ((FindableProcessor)((Object)this.internalWindowProcessor)).compileCondition(condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        }
        throw new OperationNotSupportedException("Cannot construct finder for the window " + this.windowDefinition.getWindow());
    }

    public LockWrapper getLock() {
        return this.lockWrapper;
    }

    public ProcessingMode getProcessingMode() {
        return this.internalWindowProcessor.getProcessingMode();
    }

    private class StreamPublishProcessor
    implements Processor {
        private final boolean allowCurrentEvents;
        private final boolean allowExpiredEvents;
        private final OutputStream.OutputEventType outputEventType;

        StreamPublishProcessor(OutputStream.OutputEventType outputEventType) {
            this.outputEventType = outputEventType;
            this.allowCurrentEvents = outputEventType == OutputStream.OutputEventType.CURRENT_EVENTS || outputEventType == OutputStream.OutputEventType.ALL_EVENTS;
            this.allowExpiredEvents = outputEventType == OutputStream.OutputEventType.EXPIRED_EVENTS || outputEventType == OutputStream.OutputEventType.ALL_EVENTS;
        }

        @Override
        public void process(ComplexEventChunk complexEventChunk) {
            if (Window.this.throughputTrackerInsert != null && Level.BASIC.compareTo(Window.this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                Window.this.latencyTrackerInsert.markOut();
            }
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                if (event.getType() == ComplexEvent.Type.CURRENT && this.allowCurrentEvents || event.getType() == ComplexEvent.Type.EXPIRED && this.allowExpiredEvents) continue;
                complexEventChunk.remove();
            }
            complexEventChunk.reset();
            if (complexEventChunk.hasNext()) {
                Window.this.outputPublisher.send((ComplexEvent)complexEventChunk.getFirst());
            }
        }

        @Override
        public Processor getNextProcessor() {
            return null;
        }

        @Override
        public void setNextProcessor(Processor processor) {
        }

        @Override
        public void setToLast(Processor processor) {
        }
    }
}

