/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.time;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LastGroupByPerTimeOutputRateLimiter
extends OutputRateLimiter<RateLimiterState>
implements Schedulable {
    private static final Logger log = Logger.getLogger(LastGroupByPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private Scheduler scheduler;

    public LastGroupByPerTimeOutputRateLimiter(String id, Long value) {
        this.id = id;
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext);
        this.scheduler.setStreamEventFactory(new StreamEventFactory(0, 0, 0));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>();
        complexEventChunk.reset();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                while (complexEventChunk.hasNext()) {
                    Object event = complexEventChunk.next();
                    if (event.getType() == ComplexEvent.Type.TIMER) {
                        if (event.getTimestamp() < state.scheduledTime) continue;
                        if (state.allGroupByKeyEvents.size() != 0) {
                            for (ComplexEvent complexEvent : state.allGroupByKeyEvents.values()) {
                                outputEventChunk.add(complexEvent);
                            }
                            state.allGroupByKeyEvents.clear();
                        }
                        state.scheduledTime += this.value.longValue();
                        this.scheduler.notifyAt(state.scheduledTime);
                        continue;
                    }
                    if (event.getType() != ComplexEvent.Type.CURRENT && event.getType() != ComplexEvent.Type.EXPIRED) continue;
                    complexEventChunk.remove();
                    GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)event;
                    state.allGroupByKeyEvents.put(groupedComplexEvent.getGroupKey(), groupedComplexEvent.getComplexEvent());
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        outputEventChunk.reset();
        if (outputEventChunk.hasNext()) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionCreated() {
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                long currentTime = System.currentTimeMillis();
                state.scheduledTime = currentTime + this.value;
                this.scheduler.notifyAt(state.scheduledTime);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class RateLimiterState
    extends State {
        public long scheduledTime;
        private Map<String, ComplexEvent> allGroupByKeyEvents = new LinkedHashMap<String, ComplexEvent>();

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.allGroupByKeyEvents.size() == 0 && this.scheduledTime == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("AllGroupByKeyEvents", this.allGroupByKeyEvents);
            state.put("ScheduledTime", this.scheduledTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.allGroupByKeyEvents = (Map)state.get("AllGroupByKeyEvents");
            this.scheduledTime = (Long)state.get("ScheduledTime");
        }
    }
}

