/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.CompiledUpdateSet;
import io.siddhi.core.table.InMemoryCompiledCondition;
import io.siddhi.core.table.InMemoryCompiledUpdateSet;
import io.siddhi.core.table.InMemoryTable;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.holder.EventHolder;
import io.siddhi.core.table.holder.IndexEventHolderForCache;
import io.siddhi.core.table.record.RecordTableHandler;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.EventHolderPasser;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.And;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.util.AnnotationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class CacheTable
extends InMemoryTable {
    private int maxSize;
    private boolean cacheExpiryEnabled;

    @Override
    public void init(TableDefinition tableDefinition, StreamEventFactory storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler) {
        this.tableDefinition = tableDefinition;
        this.tableStreamEventCloner = storeEventCloner;
        EventHolder eventHolder = EventHolderPasser.parse((AbstractDefinition)tableDefinition, storeEventPool, siddhiAppContext, true);
        if (eventHolder instanceof IndexEventHolderForCache) {
            ((IndexEventHolderForCache)eventHolder).setCacheTable(this);
        }
        this.stateHolder = siddhiAppContext.generateStateHolder(tableDefinition.getId(), () -> new InMemoryTable.TableState(this, eventHolder));
    }

    public void initCacheTable(TableDefinition cacheTableDefinition, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler, boolean cacheExpiryEnabled, int maxSize, String cachePolicy) {
        this.maxSize = maxSize;
        this.cacheExpiryEnabled = cacheExpiryEnabled;
        this.siddhiAppContext = siddhiAppContext;
        this.addRequiredFieldsToCacheTableDefinition(cacheTableDefinition, cacheExpiryEnabled);
        MetaStreamEvent cacheTableMetaStreamEvent = new MetaStreamEvent();
        cacheTableMetaStreamEvent.addInputDefinition((AbstractDefinition)cacheTableDefinition);
        for (Attribute attribute : cacheTableDefinition.getAttributeList()) {
            cacheTableMetaStreamEvent.addOutputData(attribute);
        }
        StreamEventFactory cacheTableStreamEventFactory = new StreamEventFactory(cacheTableMetaStreamEvent);
        StreamEventCloner cacheTableStreamEventCloner = new StreamEventCloner(cacheTableMetaStreamEvent, cacheTableStreamEventFactory);
        super.initTable(cacheTableDefinition, cacheTableStreamEventFactory, cacheTableStreamEventCloner, configReader, siddhiAppContext, recordTableHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamEventUptoMaxSize(StreamEvent streamEvent) {
        ComplexEventChunk<StreamEvent> addEventsLimitCopy = new ComplexEventChunk<StreamEvent>();
        for (int sizeAfterAdding = this.size(); sizeAfterAdding < this.maxSize && streamEvent != null; ++sizeAfterAdding, streamEvent = streamEvent.getNext()) {
            addEventsLimitCopy.add((StreamEvent)this.generateEventWithRequiredFields(streamEvent, this.siddhiAppContext, this.cacheExpiryEnabled));
        }
        this.readWriteLock.writeLock().lock();
        try {
            this.add(addEventsLimitCopy);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndTrimUptoMaxSize(ComplexEventChunk<StreamEvent> addingEventChunk) {
        ComplexEventChunk<StreamEvent> addingEventChunkForCache = new ComplexEventChunk<StreamEvent>();
        addingEventChunk.reset();
        while (addingEventChunk.hasNext()) {
            StreamEvent event = (StreamEvent)addingEventChunk.next();
            addingEventChunkForCache.add((StreamEvent)this.generateEventWithRequiredFields(event, this.siddhiAppContext, this.cacheExpiryEnabled));
        }
        this.readWriteLock.writeLock().lock();
        try {
            super.add(addingEventChunkForCache);
            if (this.size() > this.maxSize) {
                this.deleteEntriesUsingCachePolicy(this.size() - this.maxSize);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrAddAndTrimUptoMaxSize(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor, int maxTableSize) {
        ComplexEventChunk<StateEvent> updateOrAddingEventChunkForCache = new ComplexEventChunk<StateEvent>();
        updateOrAddingEventChunk.reset();
        while (updateOrAddingEventChunk.hasNext()) {
            StateEvent event = (StateEvent)updateOrAddingEventChunk.next();
            updateOrAddingEventChunkForCache.add((StateEvent)this.generateEventWithRequiredFields(event, this.siddhiAppContext, this.cacheExpiryEnabled));
        }
        this.readWriteLock.writeLock().lock();
        InMemoryTable.TableState state = (InMemoryTable.TableState)this.stateHolder.getState();
        try {
            InMemoryCompiledCondition inMemoryCompiledCondition = (InMemoryCompiledCondition)compiledCondition;
            ComplexEventChunk<StateEvent> failedEvents = ((Operator)inMemoryCompiledCondition.getOperatorCompiledCondition()).tryUpdate(updateOrAddingEventChunkForCache, state.getEventHolder(), (InMemoryCompiledUpdateSet)compiledUpdateSet, addingStreamEventExtractor);
            if (failedEvents != null && failedEvents.getFirst() != null) {
                state.getEventHolder().add(this.reduceEventsForUpdateOrInsert(addingStreamEventExtractor, inMemoryCompiledCondition, (InMemoryCompiledUpdateSet)compiledUpdateSet, failedEvents));
            }
            if (this.size() > this.maxSize) {
                this.deleteEntriesUsingCachePolicy(this.size() - this.maxSize);
            }
        }
        finally {
            this.stateHolder.returnState(state);
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void deleteAll() {
        this.readWriteLock.writeLock().lock();
        try {
            ((InMemoryTable.TableState)this.stateHolder.getState()).getEventHolder().deleteAll();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    abstract void addRequiredFieldsToCacheTableDefinition(TableDefinition var1, boolean var2);

    public abstract void deleteOneEntryUsingCachePolicy();

    public abstract void deleteEntriesUsingCachePolicy(int var1);

    ComplexEvent generateEventWithRequiredFields(ComplexEvent event, SiddhiAppContext siddhiAppContext, boolean cacheExpiryEnabled) {
        if (event instanceof StreamEvent) {
            StreamEvent eventForCache = this.addRequiredFields(event, siddhiAppContext, cacheExpiryEnabled);
            return eventForCache;
        }
        if (event instanceof StateEvent) {
            StreamEvent eventForCache = this.addRequiredFields(((StateEvent)event).getStreamEvent(0), siddhiAppContext, cacheExpiryEnabled);
            StateEvent stateEvent = new StateEvent(((StateEvent)event).getStreamEvents().length, eventForCache.getOutputData().length);
            stateEvent.addEvent(0, eventForCache);
            return stateEvent;
        }
        return null;
    }

    protected abstract StreamEvent addRequiredFields(ComplexEvent var1, SiddhiAppContext var2, boolean var3);

    public CacheCompiledConditionWithRouteToCache generateCacheCompileCondition(Expression condition, MatchingMetaInfoHolder storeMatchingMetaInfoHolder, SiddhiQueryContext siddhiQueryContext, List<VariableExpressionExecutor> storeVariableExpressionExecutors) {
        boolean routeToCache = this.checkConditionToRouteToCache(condition, storeMatchingMetaInfoHolder);
        MetaStateEvent metaStateEvent = new MetaStateEvent(storeMatchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents().length);
        for (MetaStreamEvent referenceMetaStreamEvent : storeMatchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents()) {
            metaStateEvent.addEvent(referenceMetaStreamEvent);
        }
        MatchingMetaInfoHolder matchingMetaInfoHolder = new MatchingMetaInfoHolder(metaStateEvent, storeMatchingMetaInfoHolder.getMatchingStreamEventIndex(), storeMatchingMetaInfoHolder.getStoreEventIndex(), storeMatchingMetaInfoHolder.getMatchingStreamDefinition(), (AbstractDefinition)this.tableDefinition, storeMatchingMetaInfoHolder.getCurrentState());
        ConcurrentHashMap<String, Table> tableMap = new ConcurrentHashMap<String, Table>();
        tableMap.put(this.tableDefinition.getId(), this);
        return new CacheCompiledConditionWithRouteToCache(this.compileCondition(condition, matchingMetaInfoHolder, storeVariableExpressionExecutors, tableMap, siddhiQueryContext, routeToCache), routeToCache);
    }

    private boolean checkConditionToRouteToCache(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder) {
        ArrayList<String> primaryKeysArray = new ArrayList<String>();
        Annotation primaryKeys = AnnotationHelper.getAnnotation((String)"PrimaryKey", (List)this.tableDefinition.getAnnotations());
        if (primaryKeys == null) {
            return false;
        }
        List keys = primaryKeys.getElements();
        for (Element element : keys) {
            primaryKeysArray.add(element.getValue());
        }
        this.recursivelyCheckConditionToRouteToCache(condition, primaryKeysArray, matchingMetaInfoHolder);
        return primaryKeysArray.size() == 0;
    }

    private void recursivelyCheckConditionToRouteToCache(Expression condition, List<String> primaryKeysArray, MatchingMetaInfoHolder matchingMetaInfoHolder) {
        if (condition instanceof Compare) {
            Compare compareCondition = (Compare)condition;
            if (compareCondition.getOperator() == Compare.Operator.EQUAL) {
                Variable variable;
                if (compareCondition.getLeftExpression() instanceof Variable && this.checkIfVariableMatchesTable(variable = (Variable)compareCondition.getLeftExpression(), matchingMetaInfoHolder)) {
                    primaryKeysArray.remove(variable.getAttributeName());
                }
                if (compareCondition.getRightExpression() instanceof Variable && this.checkIfVariableMatchesTable(variable = (Variable)compareCondition.getRightExpression(), matchingMetaInfoHolder)) {
                    primaryKeysArray.remove(variable.getAttributeName());
                }
            }
        } else if (condition instanceof And) {
            this.recursivelyCheckConditionToRouteToCache(((And)condition).getLeftExpression(), primaryKeysArray, matchingMetaInfoHolder);
            this.recursivelyCheckConditionToRouteToCache(((And)condition).getRightExpression(), primaryKeysArray, matchingMetaInfoHolder);
        }
    }

    private boolean checkIfVariableMatchesTable(Variable variable, MatchingMetaInfoHolder matchingMetaInfoHolder) {
        if (variable.getStreamId() == null) {
            return false;
        }
        if (variable.getStreamId().equalsIgnoreCase(this.tableDefinition.getId())) {
            return true;
        }
        for (MetaStreamEvent streamEvent : matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents()) {
            if (streamEvent.getInputReferenceId() == null || !streamEvent.getInputReferenceId().equalsIgnoreCase(variable.getStreamId()) || !streamEvent.getInputDefinitions().get(0).getId().equalsIgnoreCase(this.tableDefinition.getId())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext, boolean updateCachePolicyAttribute) {
        InMemoryTable.TableState state = (InMemoryTable.TableState)this.stateHolder.getState();
        try {
            InMemoryCompiledCondition inMemoryCompiledCondition = new InMemoryCompiledCondition(OperatorParser.constructOperatorForCache(state.getEventHolder(), condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext, updateCachePolicyAttribute, this), ExpressionParser.parseExpression(condition, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext), matchingMetaInfoHolder.getStoreEventIndex());
            return inMemoryCompiledCondition;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public abstract void updateCachePolicyAttribute(StreamEvent var1);

    public class CacheCompiledConditionWithRouteToCache {
        private CompiledCondition cacheCompiledCondition;
        private boolean routeToCache;

        CacheCompiledConditionWithRouteToCache(CompiledCondition cacheCompiledCondition, boolean routeToCache) {
            this.cacheCompiledCondition = cacheCompiledCondition;
            this.routeToCache = routeToCache;
        }

        public CompiledCondition getCacheCompiledCondition() {
            return this.cacheCompiledCondition;
        }

        public boolean isRouteToCache() {
            return this.routeToCache;
        }
    }
}

