/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.error.handler.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ErrorHandlerUtils {
    private ErrorHandlerUtils() {
    }

    public static byte[] getAsBytes(Object event) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(event);
        return baos.toByteArray();
    }

    public static Object getAsObject(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream baip = new ByteArrayInputStream(byteArray);
        ObjectInputStream ois = new ObjectInputStream(baip);
        return ois.readObject();
    }

    public static byte[] getThrowableStackTraceAsBytes(Throwable throwable) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return ErrorHandlerUtils.getAsBytes(sw.toString());
    }

    public static String getOriginalPayloadString(Object originalPayloadAsObject) {
        if (originalPayloadAsObject != null) {
            return originalPayloadAsObject.toString();
        }
        return null;
    }

    public static String constructAddErrorRecordString(ComplexEventChunk<StreamEvent> eventChunk, boolean isObjectColumnPresent, TableDefinition tableDefinition, Exception e) {
        JsonObject payloadJson = new JsonObject();
        payloadJson.addProperty("isEditable", Boolean.valueOf(!isObjectColumnPresent && !(e instanceof ConnectionUnavailableException)));
        JsonArray attributes = new JsonArray();
        JsonArray records = new JsonArray();
        for (Attribute attribute : tableDefinition.getAttributeList()) {
            JsonObject attributeJson = new JsonObject();
            attributeJson.add("name", (JsonElement)new JsonPrimitive(attribute.getName()));
            attributeJson.add("type", (JsonElement)new JsonPrimitive(String.valueOf(attribute.getType())));
            attributes.add((JsonElement)attributeJson);
        }
        payloadJson.add("attributes", (JsonElement)attributes);
        while (eventChunk.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)eventChunk.next();
            JsonArray record = new JsonArray();
            for (Object item : streamEvent.getOutputData()) {
                if (item == null) {
                    record.add((JsonElement)JsonNull.INSTANCE);
                    continue;
                }
                record.add(String.valueOf(item));
            }
            records.add((JsonElement)record);
        }
        payloadJson.add("records", (JsonElement)records);
        return payloadJson.toString();
    }

    public static String constructErrorRecordString(ComplexEventChunk<StateEvent> eventChunk, boolean isObjectColumnPresent, TableDefinition tableDefinition, Exception e) {
        JsonObject payloadJson = new JsonObject();
        if (isObjectColumnPresent || e instanceof ConnectionUnavailableException) {
            payloadJson.addProperty("isEditable", Boolean.valueOf(false));
        } else {
            payloadJson.addProperty("isEditable", Boolean.valueOf(true));
        }
        JsonArray attributes = new JsonArray();
        JsonArray records = new JsonArray();
        for (Attribute attribute : tableDefinition.getAttributeList()) {
            JsonObject attributeJson = new JsonObject();
            attributeJson.add("name", (JsonElement)new JsonPrimitive(attribute.getName()));
            attributeJson.add("type", (JsonElement)new JsonPrimitive(String.valueOf(attribute.getType())));
            attributes.add((JsonElement)attributeJson);
        }
        payloadJson.add("attributes", (JsonElement)attributes);
        while (eventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)eventChunk.next();
            for (StreamEvent streamEvent : stateEvent.getStreamEvents()) {
                if (streamEvent == null) continue;
                JsonArray record = new JsonArray();
                for (Object item : streamEvent.getOutputData()) {
                    if (item == null) {
                        record.add((JsonElement)JsonNull.INSTANCE);
                        continue;
                    }
                    record.add(String.valueOf(item));
                }
                records.add((JsonElement)record);
            }
        }
        payloadJson.add("records", (JsonElement)records);
        return payloadJson.toString();
    }
}

