/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.aggregation.IncrementalExecutor;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.StoreQueryRuntime;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.IncrementalTimeConverterUtil;
import io.siddhi.core.util.parser.StoreQueryParser;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.execution.query.StoreQuery;
import io.siddhi.query.api.execution.query.input.store.InputStore;
import io.siddhi.query.api.execution.query.selection.OrderByAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.expression.constant.Constant;
import java.util.List;
import java.util.Map;

public class IncrementalExecutorsInitialiser {
    private final List<TimePeriod.Duration> incrementalDurations;
    private final Map<TimePeriod.Duration, Table> aggregationTables;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap;
    private final boolean isDistributed;
    private final String shardId;
    private final StreamEventFactory streamEventFactory;
    private final SiddhiAppContext siddhiAppContext;
    private final Map<String, Table> tableMap;
    private final Map<String, Window> windowMap;
    private final Map<String, AggregationRuntime> aggregationMap;
    private boolean isInitialised;

    public IncrementalExecutorsInitialiser(List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, Table> aggregationTables, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, boolean isDistributed, String shardId, SiddhiAppContext siddhiAppContext, MetaStreamEvent metaStreamEvent, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap) {
        this.incrementalDurations = incrementalDurations;
        this.aggregationTables = aggregationTables;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.isDistributed = isDistributed;
        this.shardId = shardId;
        this.streamEventFactory = new StreamEventFactory(metaStreamEvent);
        this.siddhiAppContext = siddhiAppContext;
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
        this.isInitialised = false;
    }

    public synchronized void initialiseExecutors() {
        if (this.isInitialised) {
            return;
        }
        Long endOFLatestEventTimestamp = null;
        Table tableForMaxDuration = this.aggregationTables.get(this.incrementalDurations.get(this.incrementalDurations.size() - 1));
        StoreQuery storeQuery = this.getStoreQuery(tableForMaxDuration, true, endOFLatestEventTimestamp);
        storeQuery.setType(StoreQuery.StoreQueryType.FIND);
        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
        Event[] events = storeQueryRuntime.execute();
        if (events != null) {
            Long lastData = (Long)events[events.length - 1].getData(0);
            endOFLatestEventTimestamp = IncrementalTimeConverterUtil.getNextEmitTime(lastData, this.incrementalDurations.get(this.incrementalDurations.size() - 1), null);
        }
        for (int i = this.incrementalDurations.size() - 1; i > 0; --i) {
            TimePeriod.Duration recreateForDuration = this.incrementalDurations.get(i);
            IncrementalExecutor incrementalExecutor = this.incrementalExecutorMap.get(recreateForDuration);
            Table recreateFromTable = this.aggregationTables.get(this.incrementalDurations.get(i - 1));
            storeQuery = this.getStoreQuery(recreateFromTable, false, endOFLatestEventTimestamp);
            storeQuery.setType(StoreQuery.StoreQueryType.FIND);
            storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
            events = storeQueryRuntime.execute();
            if (events == null) continue;
            long referenceToNextLatestEvent = (Long)events[events.length - 1].getData(0);
            endOFLatestEventTimestamp = IncrementalTimeConverterUtil.getNextEmitTime(referenceToNextLatestEvent, this.incrementalDurations.get(i - 1), null);
            ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>(false);
            for (Event event : events) {
                StreamEvent streamEvent = this.streamEventFactory.newInstance();
                streamEvent.setOutputData(event.getData());
                complexEventChunk.add(streamEvent);
            }
            incrementalExecutor.execute(complexEventChunk);
            if (i != 1) continue;
            TimePeriod.Duration rootDuration = this.incrementalDurations.get(0);
            IncrementalExecutor rootIncrementalExecutor = this.incrementalExecutorMap.get(rootDuration);
            long emitTimeOfLatestEventInTable = IncrementalTimeConverterUtil.getNextEmitTime(referenceToNextLatestEvent, rootDuration, null);
            rootIncrementalExecutor.setEmitTime(emitTimeOfLatestEventInTable);
        }
        this.isInitialised = true;
    }

    private StoreQuery getStoreQuery(Table table, boolean isLargestGranularity, Long endOFLatestEventTimestamp) {
        Selector selector = Selector.selector();
        selector = isLargestGranularity ? selector.orderBy(Expression.variable((String)"AGG_TIMESTAMP"), OrderByAttribute.Order.DESC).limit((Constant)Expression.value((int)1)) : selector.orderBy(Expression.variable((String)"AGG_TIMESTAMP"));
        Object inputStore = !this.isDistributed ? (endOFLatestEventTimestamp == null ? InputStore.store((String)table.getTableDefinition().getId()) : InputStore.store((String)table.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.value((long)endOFLatestEventTimestamp)))) : (endOFLatestEventTimestamp == null ? InputStore.store((String)table.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId))) : InputStore.store((String)table.getTableDefinition().getId()).on(Expression.and((Expression)Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId)), (Expression)Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.value((long)endOFLatestEventTimestamp)))));
        return StoreQuery.query().from((InputStore)inputStore).select(selector);
    }
}

