/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream;

import io.siddhi.core.event.ComplexEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class StreamEvent
implements ComplexEvent {
    private static final long serialVersionUID = 8427059374772140103L;
    protected long timestamp = -1L;
    protected Object[] outputData;
    protected ComplexEvent.Type type = ComplexEvent.Type.CURRENT;
    private Object[] beforeWindowData;
    private Object[] onAfterWindowData;
    private StreamEvent next;

    public StreamEvent(int beforeWindowDataSize, int onAfterWindowDataSize, int outputDataSize) {
        if (beforeWindowDataSize > 0) {
            this.beforeWindowData = new Object[beforeWindowDataSize];
        }
        if (onAfterWindowDataSize > 0) {
            this.onAfterWindowData = new Object[onAfterWindowDataSize];
        }
        if (outputDataSize > 0) {
            this.outputData = new Object[outputDataSize];
        }
    }

    public Object[] getBeforeWindowData() {
        return this.beforeWindowData;
    }

    public void setBeforeWindowData(Object[] beforeWindowData) {
        this.beforeWindowData = beforeWindowData;
    }

    public Object[] getOnAfterWindowData() {
        return this.onAfterWindowData;
    }

    public void setOnAfterWindowData(Object[] onAfterWindowData) {
        this.onAfterWindowData = onAfterWindowData;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Object[] getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Object[] outputData) {
        this.outputData = outputData;
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public ComplexEvent.Type getType() {
        return this.type;
    }

    @Override
    public void setType(ComplexEvent.Type type) {
        this.type = type;
    }

    @Override
    public StreamEvent getNext() {
        return this.next;
    }

    @Override
    public void setNext(ComplexEvent next) {
        this.next = (StreamEvent)next;
    }

    @Override
    public Object getAttribute(int[] position) {
        switch (position[2]) {
            case 0: {
                return this.beforeWindowData[position[3]];
            }
            case 2: {
                return this.outputData[position[3]];
            }
            case 1: {
                return this.onAfterWindowData[position[3]];
            }
        }
        throw new IllegalStateException("STREAM_ATTRIBUTE_TYPE_INDEX cannot be " + position[2]);
    }

    @Override
    public void setAttribute(Object object, int[] position) {
        switch (position[2]) {
            case 0: {
                this.beforeWindowData[position[3]] = object;
                break;
            }
            case 2: {
                this.outputData[position[3]] = object;
                break;
            }
            case 1: {
                this.onAfterWindowData[position[3]] = object;
                break;
            }
            default: {
                throw new IllegalStateException("STREAM_ATTRIBUTE_TYPE_INDEX cannot be " + position[2]);
            }
        }
    }

    @Override
    public void setOutputData(Object object, int index) {
        this.outputData[index] = object;
    }

    public void setOnAfterWindowData(Object object, int index) {
        this.onAfterWindowData[index] = object;
    }

    public void setBeforeWindowData(Object object, int index) {
        this.beforeWindowData[index] = object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamEvent)) {
            return false;
        }
        StreamEvent event = (StreamEvent)o;
        if (this.type != event.type) {
            return false;
        }
        if (this.timestamp != event.timestamp) {
            return false;
        }
        if (!Arrays.equals(this.beforeWindowData, event.beforeWindowData)) {
            return false;
        }
        if (!Arrays.equals(this.onAfterWindowData, event.onAfterWindowData)) {
            return false;
        }
        return Arrays.equals(this.outputData, event.outputData);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.beforeWindowData != null ? Arrays.hashCode(this.beforeWindowData) : 0);
        result = 31 * result + (this.onAfterWindowData != null ? Arrays.hashCode(this.onAfterWindowData) : 0);
        result = 31 * result + (this.outputData != null ? Arrays.hashCode(this.outputData) : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.toString(100L);
    }

    public String toString(long maxNoOfEventsToPrint) {
        if (maxNoOfEventsToPrint == 0L) {
            return "...";
        }
        return "StreamEvent{ timestamp=" + this.timestamp + ", beforeWindowData=" + (this.beforeWindowData == null ? "null" : Arrays.asList(this.beforeWindowData).toString()) + ", onAfterWindowData=" + (this.onAfterWindowData == null ? "null" : Arrays.asList(this.onAfterWindowData).toString()) + ", outputData=" + (this.outputData == null ? "null" : Arrays.asList(this.outputData).toString()) + ", type=" + (Object)((Object)this.type) + ", next=" + (this.next != null ? this.next.toString(maxNoOfEventsToPrint - 1L) : "null") + '}';
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.beforeWindowData);
        stream.writeObject(this.onAfterWindowData);
        stream.writeObject(this.outputData);
        stream.writeObject((Object)this.type);
        stream.writeLong(this.timestamp);
        for (StreamEvent nextEvent = this.next; nextEvent != null; nextEvent = nextEvent.getNext()) {
            stream.writeBoolean(true);
            stream.writeObject(nextEvent.beforeWindowData);
            stream.writeObject(nextEvent.onAfterWindowData);
            stream.writeObject(nextEvent.outputData);
            stream.writeObject((Object)nextEvent.type);
            stream.writeLong(nextEvent.timestamp);
        }
        stream.writeBoolean(false);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.beforeWindowData = (Object[])stream.readObject();
        this.onAfterWindowData = (Object[])stream.readObject();
        this.outputData = (Object[])stream.readObject();
        this.type = (ComplexEvent.Type)((Object)stream.readObject());
        this.timestamp = stream.readLong();
        StreamEvent previousStreamEvent = this;
        boolean isNextAvailable = stream.readBoolean();
        while (isNextAvailable) {
            StreamEvent nextEvent = new StreamEvent(0, 0, 0);
            nextEvent.beforeWindowData = (Object[])stream.readObject();
            nextEvent.onAfterWindowData = (Object[])stream.readObject();
            nextEvent.outputData = (Object[])stream.readObject();
            nextEvent.type = (ComplexEvent.Type)((Object)stream.readObject());
            nextEvent.timestamp = stream.readLong();
            previousStreamEvent.next = nextEvent;
            previousStreamEvent = nextEvent;
            isNextAvailable = stream.readBoolean();
        }
    }
}

