/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.StoreQueryRuntimeException;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.List;

public abstract class StoreQueryRuntime {
    String queryName;
    MetaStreamEvent.EventType eventType;
    QuerySelector selector;
    StateEventFactory stateEventFactory;
    MetaStreamEvent metaStreamEvent;
    Attribute[] outputAttributes;

    public Event[] execute() {
        try {
            StateEvent stateEvent = new StateEvent(1, this.outputAttributes.length);
            StreamEvent streamEvent = new StreamEvent(this.metaStreamEvent.getBeforeWindowData().size(), this.metaStreamEvent.getOnAfterWindowData().size(), this.metaStreamEvent.getOutputData().size());
            stateEvent.addEvent(0, streamEvent);
            ComplexEventChunk<StateEvent> complexEventChunk = new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, true);
            if (this.eventType != MetaStreamEvent.EventType.TABLE) {
                throw new StoreQueryRuntimeException("DELETE, INSERT, UPDATE and UPDATE OR INSERT store query operations consume only stream events of type \"TABLE\".");
            }
            this.selector.process(complexEventChunk);
            return new Event[0];
        }
        catch (Throwable t) {
            throw new StoreQueryRuntimeException("Error executing '" + this.queryName + "', " + t.getMessage(), t);
        }
    }

    public void setStateEventFactory(StateEventFactory stateEventFactory) {
        this.stateEventFactory = stateEventFactory;
    }

    public void setOutputAttributes(List<Attribute> outputAttributeList) {
        this.outputAttributes = outputAttributeList.toArray(new Attribute[outputAttributeList.size()]);
    }

    public Attribute[] getStoreQueryOutputAttributes() {
        return Arrays.copyOf(this.outputAttributes, this.outputAttributes.length);
    }

    public void setSelector(QuerySelector selector) {
        this.selector = selector;
    }

    public abstract void reset();

    public abstract TYPE getType();

    public void setMetaStreamEvent(MetaStreamEvent metaStreamEvent) {
        this.metaStreamEvent = metaStreamEvent;
    }

    static enum TYPE {
        DELETE,
        INSERT,
        SELECT,
        UPDATE,
        UPDATE_OR_INSERT,
        FIND;

    }
}

