/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.event.stream.converter.StreamEventConverterFactory;
import io.siddhi.core.query.input.ProcessStreamReceiver;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.util.statistics.LatencyTracker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiProcessStreamReceiver
extends ProcessStreamReceiver {
    private static ThreadLocal<ReturnEventHolder> multiProcessReturn = new ThreadLocal();
    protected Processor[] nextProcessors;
    protected int[] eventSequence;
    private final Object patternSyncObject;
    protected OutputRateLimiter outputRateLimiter;
    private MetaStreamEvent[] metaStreamEvents;
    private StreamEventFactory[] streamEventFactorys;
    private StreamEventConverter[] streamEventConverters;

    public MultiProcessStreamReceiver(String streamId, int processCount, Object patternSyncObject, SiddhiQueryContext siddhiQueryContext) {
        super(streamId, siddhiQueryContext);
        this.nextProcessors = new Processor[processCount];
        this.metaStreamEvents = new MetaStreamEvent[processCount];
        this.streamEventFactorys = new StreamEventFactory[processCount];
        this.streamEventConverters = new StreamEventConverter[processCount];
        this.eventSequence = new int[processCount];
        this.patternSyncObject = patternSyncObject;
        for (int i = 0; i < this.eventSequence.length; ++i) {
            this.eventSequence[i] = i;
        }
    }

    public static ThreadLocal<ReturnEventHolder> getMultiProcessReturn() {
        return multiProcessReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(int eventSequence, StreamEvent newEvent) {
        block9: {
            if (this.lockWrapper != null) {
                this.lockWrapper.lock();
            }
            try {
                LatencyTracker latencyTracker = this.siddhiQueryContext.getLatencyTracker();
                if (latencyTracker != null) {
                    try {
                        latencyTracker.markIn();
                        this.processAndClear(eventSequence, newEvent);
                        break block9;
                    }
                    finally {
                        latencyTracker.markOut();
                    }
                }
                this.processAndClear(eventSequence, newEvent);
            }
            finally {
                if (this.lockWrapper != null) {
                    this.lockWrapper.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(ComplexEvent complexEvent) {
        ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
        Object object = this.patternSyncObject;
        synchronized (object) {
            for (ComplexEvent aComplexEvent = complexEvent; aComplexEvent != null; aComplexEvent = aComplexEvent.getNext()) {
                try {
                    multiProcessReturn.set(new ReturnEventHolder());
                    this.stabilizeStates(aComplexEvent.getTimestamp());
                    for (Object anEventSequence : (Object)this.eventSequence) {
                        StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                        StreamEventFactory aStreamEventFactory = this.streamEventFactorys[anEventSequence];
                        StreamEvent newEvent = aStreamEventFactory.newInstance();
                        aStreamEventConverter.convertComplexEvent(aComplexEvent, newEvent);
                        this.process((int)anEventSequence, newEvent);
                        if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                        returnEventHolderList.add(multiProcessReturn.get());
                        multiProcessReturn.set(new ReturnEventHolder());
                    }
                    continue;
                }
                finally {
                    multiProcessReturn.set(null);
                }
            }
            for (ReturnEventHolder returnEventHolder : returnEventHolderList) {
                this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Event event) {
        ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
        Iterator iterator = this.patternSyncObject;
        synchronized (iterator) {
            try {
                multiProcessReturn.set(new ReturnEventHolder());
                this.stabilizeStates(event.getTimestamp());
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventFactory aStreamEventFactory = this.streamEventFactorys[anEventSequence];
                    StreamEvent newEvent = aStreamEventFactory.newInstance();
                    aStreamEventConverter.convertEvent(event, newEvent);
                    this.process(anEventSequence, newEvent);
                    if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                    returnEventHolderList.add(multiProcessReturn.get());
                    multiProcessReturn.set(new ReturnEventHolder());
                }
            }
            finally {
                multiProcessReturn.set(null);
            }
        }
        for (ReturnEventHolder returnEventHolder : returnEventHolderList) {
            this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Event[] events) {
        ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
        Iterator iterator = this.patternSyncObject;
        synchronized (iterator) {
            for (Event event : events) {
                try {
                    multiProcessReturn.set(new ReturnEventHolder());
                    this.stabilizeStates(event.getTimestamp());
                    for (int anEventSequence : this.eventSequence) {
                        StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                        StreamEventFactory aStreamEventFactory = this.streamEventFactorys[anEventSequence];
                        StreamEvent newEvent = aStreamEventFactory.newInstance();
                        aStreamEventConverter.convertEvent(event, newEvent);
                        this.process(anEventSequence, newEvent);
                        if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                        returnEventHolderList.add(multiProcessReturn.get());
                        multiProcessReturn.set(new ReturnEventHolder());
                    }
                }
                finally {
                    multiProcessReturn.set(null);
                }
            }
        }
        for (ReturnEventHolder returnEventHolder : returnEventHolderList) {
            this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(List<Event> events) {
        ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
        Iterator iterator = this.patternSyncObject;
        synchronized (iterator) {
            for (Event event : events) {
                try {
                    multiProcessReturn.set(new ReturnEventHolder());
                    this.stabilizeStates(event.getTimestamp());
                    for (int anEventSequence : this.eventSequence) {
                        StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                        StreamEventFactory aStreamEventFactory = this.streamEventFactorys[anEventSequence];
                        StreamEvent newEvent = aStreamEventFactory.newInstance();
                        aStreamEventConverter.convertEvent(event, newEvent);
                        this.process(anEventSequence, newEvent);
                        if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                        returnEventHolderList.add(multiProcessReturn.get());
                        multiProcessReturn.set(new ReturnEventHolder());
                    }
                }
                finally {
                    multiProcessReturn.set(null);
                }
            }
        }
        for (ReturnEventHolder returnEventHolder : returnEventHolderList) {
            this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(long timestamp, Object[] data) {
        ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
        Iterator iterator = this.patternSyncObject;
        synchronized (iterator) {
            try {
                multiProcessReturn.set(new ReturnEventHolder());
                this.stabilizeStates(timestamp);
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventFactory aStreamEventFactory = this.streamEventFactorys[anEventSequence];
                    StreamEvent newEvent = aStreamEventFactory.newInstance();
                    aStreamEventConverter.convertData(timestamp, data, newEvent);
                    this.process(anEventSequence, newEvent);
                    if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                    returnEventHolderList.add(multiProcessReturn.get());
                    multiProcessReturn.set(new ReturnEventHolder());
                }
            }
            finally {
                multiProcessReturn.set(null);
            }
        }
        for (ReturnEventHolder returnEventHolder : returnEventHolderList) {
            this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
        }
    }

    protected void processAndClear(int processIndex, StreamEvent streamEvent) {
        ComplexEventChunk<StreamEvent> currentStreamEventChunk = new ComplexEventChunk<StreamEvent>(streamEvent, streamEvent, this.batchProcessingAllowed);
        this.nextProcessors[processIndex].process(currentStreamEventChunk);
    }

    protected void stabilizeStates(long timestamp) {
    }

    @Override
    public void setNext(Processor nextProcessor) {
        for (Processor processor : this.nextProcessors) {
            if (processor != null) continue;
            this.nextProcessors[i] = nextProcessor;
            break;
        }
    }

    @Override
    public void setMetaStreamEvent(MetaStreamEvent metaStreamEvent) {
        for (MetaStreamEvent streamEvent : this.metaStreamEvents) {
            if (streamEvent != null) continue;
            this.metaStreamEvents[i] = metaStreamEvent;
            break;
        }
    }

    @Override
    public boolean toStream() {
        return this.metaStreamEvents[0].getEventType() == MetaStreamEvent.EventType.DEFAULT || this.metaStreamEvents[0].getEventType() == MetaStreamEvent.EventType.WINDOW;
    }

    @Override
    public void setStreamEventFactory(StreamEventFactory streamEventFactory) {
        for (StreamEventFactory eventPool : this.streamEventFactorys) {
            if (eventPool != null) continue;
            this.streamEventFactorys[i] = streamEventFactory;
            break;
        }
    }

    @Override
    public void init() {
        int nextLength = this.streamEventConverters.length;
        for (int i = 0; i < nextLength; ++i) {
            StreamEventConverter streamEventConverter = this.streamEventConverters[i];
            if (streamEventConverter != null) continue;
            this.streamEventConverters[i] = StreamEventConverterFactory.constructEventConverter(this.metaStreamEvents[i]);
            break;
        }
    }

    public void setOutputRateLimiter(OutputRateLimiter outputRateLimiter) {
        this.outputRateLimiter = outputRateLimiter;
    }

    public class ReturnEventHolder {
        ComplexEventChunk complexEventChunk;

        public void setReturnEvents(ComplexEventChunk complexEventChunk) {
            if (this.complexEventChunk == null) {
                this.complexEventChunk = new ComplexEventChunk(complexEventChunk.isBatch());
            }
            this.complexEventChunk.add(complexEventChunk.getFirst());
        }
    }
}

