/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.join;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.FindableProcessor;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.query.processor.stream.window.TableWindowProcessor;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.query.api.definition.Attribute;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class JoinProcessor
implements Processor {
    private static final Logger log = Logger.getLogger(JoinProcessor.class);
    private boolean trigger;
    private boolean leftJoinProcessor = false;
    private boolean outerJoinProcessor = false;
    private int matchingStreamIndex;
    private boolean preJoinProcessor;
    private StateEventFactory stateEventFactory;
    private CompiledCondition compiledCondition;
    private CompiledSelection compiledSelection;
    private boolean isOptimisedQuery;
    private Attribute[] expectedOutputAttributes;
    private FindableProcessor findableProcessor;
    private Processor nextProcessor;
    private QuerySelector selector;
    private String siddhiAppName;
    private String queryName;

    public JoinProcessor(boolean leftJoinProcessor, boolean preJoinProcessor, boolean outerJoinProcessor, int matchingStreamIndex, String siddhiAppName, String queryName) {
        this.leftJoinProcessor = leftJoinProcessor;
        this.preJoinProcessor = preJoinProcessor;
        this.outerJoinProcessor = outerJoinProcessor;
        this.matchingStreamIndex = matchingStreamIndex;
        this.siddhiAppName = siddhiAppName;
        this.queryName = queryName;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (this.trigger) {
            LinkedList<JoinReturnEventChunk> returnEventChunkList = new LinkedList<JoinReturnEventChunk>();
            StateEvent joinStateEvent = new StateEvent(2, 0);
            StreamEvent nextEvent = (StreamEvent)complexEventChunk.getFirst();
            complexEventChunk.clear();
            while (nextEvent != null) {
                StreamEvent nextFoundStreamEvent;
                ComplexEventChunk<ComplexEvent> returnEventChunk;
                StreamEvent foundStreamEvent;
                StreamEvent streamEvent = nextEvent;
                nextEvent = streamEvent.getNext();
                streamEvent.setNext(null);
                ComplexEvent.Type eventType = streamEvent.getType();
                if (eventType == ComplexEvent.Type.TIMER) continue;
                if (eventType == ComplexEvent.Type.RESET) {
                    StateEvent outputStateEvent;
                    if (!this.leftJoinProcessor) {
                        outputStateEvent = this.joinEventBuilder(null, streamEvent, eventType);
                        returnEventChunkList.add(new JoinReturnEventChunk(new ComplexEventChunk<ComplexEvent>(outputStateEvent, outputStateEvent, true), true));
                        continue;
                    }
                    outputStateEvent = this.joinEventBuilder(streamEvent, null, eventType);
                    returnEventChunkList.add(new JoinReturnEventChunk(new ComplexEventChunk<ComplexEvent>(outputStateEvent, outputStateEvent, true), true));
                    continue;
                }
                joinStateEvent.setEvent(this.matchingStreamIndex, streamEvent);
                if (this.isOptimisedQuery) {
                    try {
                        foundStreamEvent = this.query(joinStateEvent);
                    }
                    catch (SiddhiAppRuntimeException e) {
                        log.warn((Object)("Performing select clause in databases failed due to '" + e.getMessage() + " in query '" + this.queryName + "' within Siddhi app '" + this.siddhiAppName + "' hence reverting back to querying only with where clause."), (Throwable)e);
                        this.isOptimisedQuery = false;
                        foundStreamEvent = this.findableProcessor.find(joinStateEvent, this.compiledCondition);
                    }
                } else {
                    foundStreamEvent = this.findableProcessor.find(joinStateEvent, this.compiledCondition);
                }
                joinStateEvent.setEvent(this.matchingStreamIndex, null);
                if (foundStreamEvent == null) {
                    StateEvent outputStateEvent;
                    if (this.outerJoinProcessor && !this.leftJoinProcessor) {
                        outputStateEvent = this.joinEventBuilder(null, streamEvent, eventType);
                        returnEventChunkList.add(new JoinReturnEventChunk(new ComplexEventChunk<ComplexEvent>(outputStateEvent, outputStateEvent, true), true));
                        continue;
                    }
                    if (!this.outerJoinProcessor || !this.leftJoinProcessor) continue;
                    outputStateEvent = this.joinEventBuilder(streamEvent, null, eventType);
                    returnEventChunkList.add(new JoinReturnEventChunk(new ComplexEventChunk<ComplexEvent>(outputStateEvent, outputStateEvent, true), true));
                    continue;
                }
                if (!this.isOptimisedQuery) {
                    returnEventChunk = new ComplexEventChunk<ComplexEvent>(true);
                    while (foundStreamEvent != null) {
                        nextFoundStreamEvent = foundStreamEvent.getNext();
                        foundStreamEvent.setNext(null);
                        if (!this.leftJoinProcessor) {
                            returnEventChunk.add(this.joinEventBuilder(foundStreamEvent, streamEvent, eventType));
                        } else {
                            returnEventChunk.add(this.joinEventBuilder(streamEvent, foundStreamEvent, eventType));
                        }
                        foundStreamEvent = nextFoundStreamEvent;
                    }
                    returnEventChunkList.add(new JoinReturnEventChunk(returnEventChunk, true));
                    continue;
                }
                returnEventChunk = new ComplexEventChunk(true);
                while (foundStreamEvent != null) {
                    nextFoundStreamEvent = foundStreamEvent.getNext();
                    foundStreamEvent.setNext(null);
                    foundStreamEvent.setType(eventType);
                    returnEventChunk.add(foundStreamEvent);
                    foundStreamEvent = nextFoundStreamEvent;
                }
                returnEventChunkList.add(new JoinReturnEventChunk(returnEventChunk, false));
            }
            for (JoinReturnEventChunk joinReturnEventChunk : returnEventChunkList) {
                ComplexEventChunk<ComplexEvent> returnEventChunk = joinReturnEventChunk.getReturnComplexEvent();
                if (returnEventChunk.getFirst() == null) continue;
                if (joinReturnEventChunk.isRegularJoin()) {
                    this.selector.process(returnEventChunk);
                } else {
                    this.selector.executePassThrough(returnEventChunk);
                }
                returnEventChunk.clear();
            }
        } else if (this.preJoinProcessor) {
            this.nextProcessor.process(complexEventChunk);
        }
    }

    private StreamEvent query(StateEvent joinStateEvent) throws SiddhiAppRuntimeException {
        Table table = ((TableWindowProcessor)this.findableProcessor).getTable();
        if (table.getIsConnected()) {
            try {
                return ((QueryableProcessor)this.findableProcessor).query(joinStateEvent, this.compiledCondition, this.compiledSelection, this.expectedOutputAttributes);
            }
            catch (ConnectionUnavailableException e) {
                table.setIsConnectedToFalse();
                table.connectWithRetry();
                return this.query(joinStateEvent);
            }
        }
        if (table.getIsTryingToConnect()) {
            log.warn((Object)("Error while performing query '" + this.queryName + "' within Siddhi app '" + this.siddhiAppName + "' for event '" + joinStateEvent + "', operation busy waiting at Table '" + table.getTableDefinition().getId() + "' as its trying to reconnect!"));
            table.waitWhileConnect();
            log.info((Object)("Table '" + table.getTableDefinition().getId() + "' has become available for query '" + this.queryName + "' within Siddhi app '" + this.siddhiAppName + "for matching event '" + joinStateEvent + "'"));
            return this.query(joinStateEvent);
        }
        table.connectWithRetry();
        return this.query(joinStateEvent);
    }

    public void setCompiledSelection(CompiledSelection compiledSelection) {
        if (compiledSelection != null) {
            this.isOptimisedQuery = true;
            this.compiledSelection = compiledSelection;
        }
    }

    public void setExpectedOutputAttributes(List<Attribute> expectedOutputAttributes) {
        this.expectedOutputAttributes = expectedOutputAttributes.toArray(new Attribute[0]);
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
        if (processor instanceof QuerySelector) {
            this.selector = (QuerySelector)processor;
        }
    }

    public void setFindableProcessor(FindableProcessor findableProcessor) {
        this.findableProcessor = findableProcessor;
    }

    public CompiledCondition getCompiledCondition() {
        return this.compiledCondition;
    }

    public void setCompiledCondition(CompiledCondition compiledCondition) {
        this.compiledCondition = compiledCondition;
    }

    public void setTrigger(boolean trigger) {
        this.trigger = trigger;
    }

    public void setStateEventFactory(StateEventFactory stateEventFactory) {
        this.stateEventFactory = stateEventFactory;
    }

    public CompiledSelection getCompiledSelection() {
        return this.compiledSelection;
    }

    public StateEvent joinEventBuilder(StreamEvent leftStream, StreamEvent rightStream, ComplexEvent.Type type) {
        StateEvent returnEvent = this.stateEventFactory.newInstance();
        returnEvent.setEvent(0, leftStream);
        returnEvent.setEvent(1, rightStream);
        returnEvent.setType(type);
        if (!this.leftJoinProcessor) {
            returnEvent.setTimestamp(rightStream.getTimestamp());
        } else {
            returnEvent.setTimestamp(leftStream.getTimestamp());
        }
        return returnEvent;
    }

    private class JoinReturnEventChunk {
        private ComplexEventChunk<ComplexEvent> returnComplexEvent;
        private boolean isRegularJoin;

        JoinReturnEventChunk(ComplexEventChunk<ComplexEvent> returnComplexEvent, boolean isRegularJoin) {
            this.returnComplexEvent = returnComplexEvent;
            this.isRegularJoin = isRegularJoin;
        }

        ComplexEventChunk<ComplexEvent> getReturnComplexEvent() {
            return this.returnComplexEvent;
        }

        boolean isRegularJoin() {
            return this.isRegularJoin;
        }
    }
}

