/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.input.stream.state.CountPreStateProcessor;
import io.siddhi.core.query.input.stream.state.PostStateProcessor;
import io.siddhi.core.query.input.stream.state.PreStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.core.query.processor.Processor;

public class StreamPostStateProcessor
implements PostStateProcessor {
    protected PreStateProcessor nextStatePreProcessor;
    protected PreStateProcessor nextEveryStatePreProcessor;
    protected StreamPreStateProcessor thisStatePreProcessor;
    protected Processor nextProcessor;
    protected int stateId;
    protected CountPreStateProcessor callbackPreStateProcessor;
    protected boolean isEventReturned;

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        if (complexEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)complexEventChunk.next();
            this.process(stateEvent, complexEventChunk);
        }
        complexEventChunk.clear();
    }

    protected void process(StateEvent stateEvent, ComplexEventChunk complexEventChunk) {
        this.thisStatePreProcessor.stateChanged();
        StreamEvent streamEvent = stateEvent.getStreamEvent(this.stateId);
        stateEvent.setTimestamp(streamEvent.getTimestamp());
        if (this.nextProcessor != null) {
            complexEventChunk.reset();
            this.isEventReturned = true;
        }
        if (this.nextStatePreProcessor != null) {
            this.nextStatePreProcessor.addState(stateEvent);
        }
        if (this.nextEveryStatePreProcessor != null) {
            this.nextEveryStatePreProcessor.addEveryState(stateEvent);
        }
        if (this.callbackPreStateProcessor != null) {
            this.callbackPreStateProcessor.startStateReset();
        }
    }

    public boolean isEventReturned() {
        return this.isEventReturned;
    }

    public void clearProcessedEvent() {
        this.isEventReturned = false;
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    public PreStateProcessor getNextStatePreProcessor() {
        return this.nextStatePreProcessor;
    }

    @Override
    public void setNextStatePreProcessor(PreStateProcessor preStateProcessor) {
        this.nextStatePreProcessor = preStateProcessor;
    }

    public PreStateProcessor getNextEveryStatePreProcessor() {
        return this.nextEveryStatePreProcessor;
    }

    @Override
    public void setNextEveryStatePreProcessor(PreStateProcessor nextEveryStatePreProcessor) {
        this.nextEveryStatePreProcessor = nextEveryStatePreProcessor;
    }

    public PreStateProcessor getThisStatePreProcessor() {
        return this.thisStatePreProcessor;
    }

    public void setThisStatePreProcessor(StreamPreStateProcessor preStateProcessor) {
        this.thisStatePreProcessor = preStateProcessor;
    }

    @Override
    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    @Override
    public void setCallbackPreStateProcessor(CountPreStateProcessor callbackPreStateProcessor) {
        this.callbackPreStateProcessor = callbackPreStateProcessor;
    }
}

