/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter<RateLimiterState> {
    private final Long value;
    private Scheduler scheduler;

    public AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter(Long value, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        super(wrappedSnapshotOutputRateLimiter, siddhiQueryContext, groupBy);
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext);
        this.scheduler.setStreamEventFactory(new StreamEventFactory(0, 0, 0));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        complexEventChunk.reset();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                while (complexEventChunk.hasNext()) {
                    Object object = complexEventChunk.next();
                    if (object.getType() == ComplexEvent.Type.TIMER) {
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)object, state);
                        continue;
                    }
                    complexEventChunk.remove();
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object, state);
                    GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)object;
                    LastEventHolder lastEventHolder = (LastEventHolder)state.groupByKeyEvents.get(groupedComplexEvent.getGroupKey());
                    if (lastEventHolder == null) {
                        lastEventHolder = new LastEventHolder();
                        state.groupByKeyEvents.put(groupedComplexEvent.getGroupKey(), lastEventHolder);
                    }
                    if (groupedComplexEvent.getType() == ComplexEvent.Type.CURRENT) {
                        lastEventHolder.addLastInEvent(groupedComplexEvent.getComplexEvent());
                        continue;
                    }
                    if (groupedComplexEvent.getType() == ComplexEvent.Type.EXPIRED) {
                        lastEventHolder.removeLastInEvent(groupedComplexEvent.getComplexEvent());
                        continue;
                    }
                    if (groupedComplexEvent.getType() != ComplexEvent.Type.RESET) continue;
                    state.groupByKeyEvents.clear();
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event, RateLimiterState state) {
        if (event.getTimestamp() >= state.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            Iterator iterator = state.groupByKeyEvents.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry lastEventHolderEntry = iterator.next();
                ((LastEventHolder)lastEventHolderEntry.getValue()).checkAndClearLastInEvent();
                if (((LastEventHolder)lastEventHolderEntry.getValue()).lastEvent == null) {
                    iterator.remove();
                    continue;
                }
                outputEventChunk.add(this.cloneComplexEvent(((LastEventHolder)lastEventHolderEntry.getValue()).lastEvent));
            }
            outputEventChunks.add(outputEventChunk);
            state.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(state.scheduledTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionCreated() {
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                long currentTime = System.currentTimeMillis();
                state.scheduledTime = currentTime + this.value;
                this.scheduler.notifyAt(state.scheduledTime);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class RateLimiterState
    extends State {
        public long scheduledTime;
        private Map<String, LastEventHolder> groupByKeyEvents = new LinkedHashMap<String, LastEventHolder>();

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.groupByKeyEvents.isEmpty() && this.scheduledTime == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("GroupByKeyEvents", this.groupByKeyEvents);
            state.put("ScheduledTime", this.scheduledTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.groupByKeyEvents = (Map)state.get("GroupByKeyEvents");
            this.scheduledTime = (Long)state.get("ScheduledTime");
        }
    }

    private class LastEventHolder {
        long count = 0L;
        ComplexEvent lastEvent = null;

        private LastEventHolder() {
        }

        public void addLastInEvent(ComplexEvent lastEvent) {
            this.lastEvent = lastEvent;
            ++this.count;
        }

        public void removeLastInEvent(ComplexEvent lastEvent) {
            this.lastEvent = lastEvent;
            --this.count;
        }

        public void checkAndClearLastInEvent() {
            if (this.count <= 0L) {
                this.lastEvent = null;
            }
        }
    }
}

