/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.trigger;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.trigger.AbstractTrigger;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.query.api.definition.TriggerDefinition;

public class StartTrigger
extends AbstractTrigger {
    private TriggerDefinition triggerDefinition;
    private SiddhiAppContext siddhiAppContext;
    private StreamJunction streamJunction;
    private ThroughputTracker throughputTracker;

    @Override
    public void init(TriggerDefinition triggerDefinition, SiddhiAppContext siddhiAppContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.siddhiAppContext = siddhiAppContext;
        this.streamJunction = streamJunction;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, triggerDefinition.getId(), "Trigger", null);
        }
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        if (this.throughputTracker != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
            this.throughputTracker.eventIn();
        }
        this.streamJunction.sendEvent(new Event(currentTime, new Object[]{currentTime}));
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isStateful() {
        return false;
    }
}

