/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.executor;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import java.util.Collection;
import java.util.HashSet;

public class NonCollectionExecutor
implements CollectionExecutor {
    private ExpressionExecutor expressionExecutor;

    public NonCollectionExecutor(ExpressionExecutor expressionExecutor) {
        this.expressionExecutor = expressionExecutor;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
            ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
            Collection<StreamEvent> storeEvents = indexedEventHolder.getAllEvents();
            for (StreamEvent storeEvent : storeEvents) {
                if (storeEventCloner != null) {
                    returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                    continue;
                }
                returnEventChunk.add(storeEvent);
            }
            return (StreamEvent)returnEventChunk.getFirst();
        }
        return null;
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
            return indexedEventHolder.getAllEvents();
        }
        return new HashSet<StreamEvent>();
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return (Boolean)this.expressionExecutor.execute(matchingEvent);
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        if (((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) {
            indexedEventHolder.deleteAll();
        }
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        return CollectionExecutor.Cost.MULTI_RETURN_INDEX_MATCHING;
    }
}

