/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.partition.PartitionRuntimeImpl;
import io.siddhi.core.query.QueryRuntimeImpl;
import io.siddhi.core.util.SiddhiAppRuntimeBuilder;
import io.siddhi.core.util.parser.QueryParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.partition.PartitionType;
import io.siddhi.query.api.execution.query.Query;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionParser {
    public static PartitionRuntimeImpl parse(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Partition partition, SiddhiAppContext siddhiAppContext, int queryIndex, int partitionIndex) {
        ConcurrentMap<String, AbstractDefinition> streamDefinitionMap = siddhiAppRuntimeBuilder.getStreamDefinitionMap();
        ConcurrentMap<String, AbstractDefinition> windowDefinitionMap = siddhiAppRuntimeBuilder.getWindowDefinitionMap();
        PartitionRuntimeImpl partitionRuntime = new PartitionRuntimeImpl(streamDefinitionMap, windowDefinitionMap, siddhiAppRuntimeBuilder.getStreamJunctions(), partition, partitionIndex, siddhiAppContext);
        PartitionParser.validateStreamPartitions(partition.getPartitionTypeMap(), streamDefinitionMap, windowDefinitionMap);
        for (Query query : partition.getQueryList()) {
            ArrayList<VariableExpressionExecutor> executors = new ArrayList<VariableExpressionExecutor>();
            ConcurrentHashMap<String, AbstractDefinition> combinedStreamMap = new ConcurrentHashMap<String, AbstractDefinition>();
            combinedStreamMap.putAll(streamDefinitionMap);
            combinedStreamMap.putAll(windowDefinitionMap);
            combinedStreamMap.putAll(partitionRuntime.getLocalStreamDefinitionMap());
            QueryRuntimeImpl queryRuntime = QueryParser.parse(query, siddhiAppContext, combinedStreamMap, siddhiAppRuntimeBuilder.getTableDefinitionMap(), siddhiAppRuntimeBuilder.getWindowDefinitionMap(), siddhiAppRuntimeBuilder.getAggregationDefinitionMap(), siddhiAppRuntimeBuilder.getTableMap(), siddhiAppRuntimeBuilder.getAggregationMap(), siddhiAppRuntimeBuilder.getWindowMap(), siddhiAppRuntimeBuilder.getLockSynchronizer(), String.valueOf(queryIndex), true, partitionRuntime.getPartitionName());
            ++queryIndex;
            MetaStateEvent metaStateEvent = PartitionParser.createMetaEventForPartitioner(queryRuntime.getMetaComplexEvent());
            partitionRuntime.addQuery(queryRuntime);
            partitionRuntime.addPartitionReceiver(queryRuntime, executors, metaStateEvent);
            QueryParserHelper.reduceMetaComplexEvent(metaStateEvent);
            if (queryRuntime.getMetaComplexEvent() instanceof MetaStateEvent) {
                QueryParserHelper.updateVariablePosition(metaStateEvent, executors);
                continue;
            }
            QueryParserHelper.updateVariablePosition(metaStateEvent.getMetaStreamEvent(0), executors);
        }
        partitionRuntime.init();
        return partitionRuntime;
    }

    private static void validateStreamPartitions(Map<String, PartitionType> partitionTypeMap, ConcurrentMap<String, AbstractDefinition> streamDefinitionMap, ConcurrentMap<String, AbstractDefinition> windowDefinitionMap) {
        for (Map.Entry<String, PartitionType> entry : partitionTypeMap.entrySet()) {
            if (streamDefinitionMap.containsKey(entry.getKey()) || windowDefinitionMap.containsKey(entry.getKey())) continue;
            throw new SiddhiAppCreationException("Stream/window with name '" + entry.getKey() + "' does not defined!", entry.getValue().getQueryContextStartIndex(), entry.getValue().getQueryContextEndIndex());
        }
    }

    private static MetaStateEvent createMetaEventForPartitioner(MetaComplexEvent stateEvent) {
        MetaStateEvent metaStateEvent;
        if (stateEvent instanceof MetaStateEvent) {
            metaStateEvent = new MetaStateEvent(((MetaStateEvent)stateEvent).getStreamEventCount());
            for (MetaStreamEvent metaStreamEvent : ((MetaStateEvent)stateEvent).getMetaStreamEvents()) {
                AbstractDefinition definition = metaStreamEvent.getLastInputDefinition();
                MetaStreamEvent newMetaStreamEvent = new MetaStreamEvent();
                for (Attribute attribute : definition.getAttributeList()) {
                    newMetaStreamEvent.addOutputData(attribute);
                }
                newMetaStreamEvent.addInputDefinition(definition);
                newMetaStreamEvent.setEventType(metaStreamEvent.getEventType());
                metaStateEvent.addEvent(newMetaStreamEvent);
            }
        } else {
            metaStateEvent = new MetaStateEvent(1);
            AbstractDefinition definition = ((MetaStreamEvent)stateEvent).getLastInputDefinition();
            MetaStreamEvent newMetaStreamEvent = new MetaStreamEvent();
            for (Attribute attribute : definition.getAttributeList()) {
                newMetaStreamEvent.addOutputData(attribute);
            }
            newMetaStreamEvent.addInputDefinition(definition);
            newMetaStreamEvent.setEventType(((MetaStreamEvent)stateEvent).getEventType());
            metaStateEvent.addEvent(newMetaStreamEvent);
        }
        return metaStateEvent;
    }
}

