/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;

@Extension(name="eventTimestamp", namespace="", description="Returns the timestamp of the processed/passed event.", parameters={@Parameter(name="event", description="Event reference.", type={DataType.OBJECT}, dynamic=true, optional=true, defaultValue="Current Event")}, parameterOverloads={@ParameterOverload, @ParameterOverload(parameterNames={"event"})}, returnAttributes={@ReturnAttribute(description="Timestamp of the event.", type={DataType.LONG})}, examples={@Example(syntax="from FooStream\nselect symbol as name, eventTimestamp() as eventTimestamp \ninsert into BarStream;", description="Extracts current event's timestamp."), @Example(syntax="from FooStream as f join FooBarTable as fb\nselect fb.symbol as name, eventTimestamp(f) as eventTimestamp \ninsert into BarStream;", description="Extracts FooStream event's timestamp.")})
public class EventTimestampFunctionExecutor
extends FunctionExecutor {
    private boolean expectEventObject;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 1) {
            this.expectEventObject = true;
        }
        return null;
    }

    @Override
    public Object execute(ComplexEvent event) {
        if (this.expectEventObject) {
            return ((ComplexEvent)this.attributeExpressionExecutors[0].execute(event)).getTimestamp();
        }
        return event.getTimestamp();
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }
}

