/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.event;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.HashMap;
import java.util.Map;

public class FirstPerEventOutputRateLimiter
extends OutputRateLimiter<RateLimiterState> {
    private final Integer value;

    public FirstPerEventOutputRateLimiter(String id, Integer value) {
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ComplexEventChunk<Object> outputEventChunk = new ComplexEventChunk<Object>();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                while (complexEventChunk.hasNext()) {
                    Object event = complexEventChunk.next();
                    complexEventChunk.remove();
                    state.counter++;
                    if (state.counter == 1) {
                        outputEventChunk.add(event);
                        continue;
                    }
                    if (state.counter != this.value) continue;
                    state.counter = 0;
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        outputEventChunk.reset();
        if (outputEventChunk.hasNext()) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void partitionCreated() {
    }

    class RateLimiterState
    extends State {
        private volatile int counter = 0;

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.counter == 0;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Counter", this.counter);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.counter = (Integer)state.get("Counter");
        }
    }
}

