/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.record;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.table.record.RecordTableHandlerCallback;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledExpression;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class RecordTableHandler<S extends State> {
    private String id;
    private RecordTableHandlerCallback recordTableHandlerCallback;
    private StateHolder<S> stateHolder;

    protected final void init(TableDefinition tableDefinition, RecordTableHandlerCallback recordTableHandlerCallback, SiddhiAppContext siddhiAppContext) {
        this.recordTableHandlerCallback = recordTableHandlerCallback;
        this.id = siddhiAppContext.getName() + "-" + tableDefinition.getId() + "-" + this.getClass().getName();
        StateFactory<S> stateFactory = this.init(this.id, tableDefinition);
        this.stateHolder = siddhiAppContext.generateStateHolder(tableDefinition.getId() + "-" + this.getClass().getName(), stateFactory);
    }

    public String getId() {
        return this.id;
    }

    public abstract StateFactory<S> init(String var1, TableDefinition var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long timestamp, List<Object[]> records) throws ConnectionUnavailableException {
        S state = this.stateHolder.getState();
        try {
            this.add(timestamp, records, this.recordTableHandlerCallback, state);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public abstract void add(long var1, List<Object[]> var3, RecordTableHandlerCallback var4, S var5) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long timestamp, List<Map<String, Object>> deleteConditionParameterMaps, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        S state = this.stateHolder.getState();
        try {
            this.delete(timestamp, deleteConditionParameterMaps, compiledCondition, this.recordTableHandlerCallback, state);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public abstract void delete(long var1, List<Map<String, Object>> var3, CompiledCondition var4, RecordTableHandlerCallback var5, S var6) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long timestamp, CompiledCondition compiledCondition, List<Map<String, Object>> updateConditionParameterMaps, LinkedHashMap<String, CompiledExpression> updateSetMap, List<Map<String, Object>> updateSetParameterMaps) throws ConnectionUnavailableException {
        S state = this.stateHolder.getState();
        try {
            this.update(timestamp, compiledCondition, updateConditionParameterMaps, updateSetMap, updateSetParameterMaps, this.recordTableHandlerCallback, state);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public abstract void update(long var1, CompiledCondition var3, List<Map<String, Object>> var4, LinkedHashMap<String, CompiledExpression> var5, List<Map<String, Object>> var6, RecordTableHandlerCallback var7, S var8) throws ConnectionUnavailableException;

    public void updateOrAdd(long timestamp, CompiledCondition compiledCondition, List<Map<String, Object>> updateConditionParameterMaps, LinkedHashMap<String, CompiledExpression> updateSetMap, List<Map<String, Object>> updateSetParameterMaps, List<Object[]> addingRecords) throws ConnectionUnavailableException {
        this.updateOrAdd(timestamp, compiledCondition, updateConditionParameterMaps, updateSetMap, updateSetParameterMaps, addingRecords, this.recordTableHandlerCallback);
    }

    public abstract void updateOrAdd(long var1, CompiledCondition var3, List<Map<String, Object>> var4, LinkedHashMap<String, CompiledExpression> var5, List<Map<String, Object>> var6, List<Object[]> var7, RecordTableHandlerCallback var8) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Object[]> find(long timestamp, Map<String, Object> findConditionParameterMap, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        S state = this.stateHolder.getState();
        try {
            Iterator<Object[]> iterator = this.find(timestamp, findConditionParameterMap, compiledCondition, this.recordTableHandlerCallback, state);
            return iterator;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public abstract Iterator<Object[]> find(long var1, Map<String, Object> var3, CompiledCondition var4, RecordTableHandlerCallback var5, S var6) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long timestamp, Map<String, Object> containsConditionParameterMap, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        S state = this.stateHolder.getState();
        try {
            boolean bl = this.contains(timestamp, containsConditionParameterMap, compiledCondition, this.recordTableHandlerCallback, state);
            return bl;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public abstract boolean contains(long var1, Map<String, Object> var3, CompiledCondition var4, RecordTableHandlerCallback var5, S var6) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Iterator<Object[]> query(long timestamp, Map<String, Object> parameterMap, CompiledCondition compiledCondition, CompiledSelection compiledSelection) throws ConnectionUnavailableException {
        S state = this.stateHolder.getState();
        try {
            Iterator<Object[]> iterator = this.query(timestamp, parameterMap, compiledCondition, compiledSelection, this.recordTableHandlerCallback, state);
            return iterator;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Object[]> query(long timestamp, Map<String, Object> parameterMap, CompiledCondition compiledCondition, CompiledSelection compiledSelection, Attribute[] outputAttributes) throws ConnectionUnavailableException {
        S state = this.stateHolder.getState();
        try {
            Iterator<Object[]> iterator = this.query(timestamp, parameterMap, compiledCondition, compiledSelection, outputAttributes, this.recordTableHandlerCallback, state);
            return iterator;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Deprecated
    public abstract Iterator<Object[]> query(long var1, Map<String, Object> var3, CompiledCondition var4, CompiledSelection var5, RecordTableHandlerCallback var6, S var7) throws ConnectionUnavailableException;

    public abstract Iterator<Object[]> query(long var1, Map<String, Object> var3, CompiledCondition var4, CompiledSelection var5, Attribute[] var6, RecordTableHandlerCallback var7, S var8) throws ConnectionUnavailableException;
}

