/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@Extension(name="min", namespace="", description="Returns the minimum value for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the minimum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returns the minimum value in the same type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from inputStream\nselect min(temp) as minTemp\ninsert into outputStream;", description="min(temp) returns the minimum temp value recorded for all the events based on their arrival and expiry.")})
public class MinAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<MinAggregatorState> {
    private Attribute.Type returnType;

    public void init(Attribute.Type type) {
    }

    @Override
    protected StateFactory<MinAggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Min aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        boolean trackFutureStates = false;
        if (processingMode == ProcessingMode.SLIDE || outputExpectsExpiredEvents) {
            trackFutureStates = true;
        }
        this.returnType = attributeExpressionExecutors[0].getReturnType();
        final boolean finalTrackFutureStates = trackFutureStates;
        return new StateFactory<MinAggregatorState>(){

            @Override
            public MinAggregatorState createNewState() {
                switch (MinAttributeAggregatorExecutor.this.returnType) {
                    case FLOAT: {
                        return new MinAttributeAggregatorStateFloat(finalTrackFutureStates);
                    }
                    case INT: {
                        return new MinAttributeAggregatorStateInt(finalTrackFutureStates);
                    }
                    case LONG: {
                        return new MinAttributeAggregatorStateLong(finalTrackFutureStates);
                    }
                    case DOUBLE: {
                        return new MinAttributeAggregatorStateDouble(finalTrackFutureStates);
                    }
                }
                throw new OperationNotSupportedException("Min not supported for " + MinAttributeAggregatorExecutor.this.returnType);
            }
        };
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object processAdd(Object data, MinAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data, MinAggregatorState state) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, MinAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data, MinAggregatorState state) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(MinAggregatorState state) {
        return state.reset();
    }

    abstract class MinAggregatorState
    extends State {
        MinAggregatorState() {
        }

        public abstract Object processAdd(Object var1);

        public abstract Object processRemove(Object var1);

        public abstract Object reset();

        protected abstract Object currentValue();
    }

    class MinAttributeAggregatorStateLong
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.LONG;
        private Deque<Long> minDeque = null;
        private volatile Long minValue = null;

        public MinAttributeAggregatorStateLong(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Long>();
            }
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.minDeque != null) {
                Iterator<Long> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() > value) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.isEmpty()) && this.minValue == null;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            state.put("MinDeque", this.minDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Long)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }

    class MinAttributeAggregatorStateInt
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.INT;
        private Deque<Integer> minDeque = null;
        private volatile Integer minValue = null;

        public MinAttributeAggregatorStateInt(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Integer>();
            }
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.minDeque != null) {
                Iterator<Integer> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() > value) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.isEmpty()) && this.minValue == null;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            state.put("MinDeque", this.minDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Integer)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }

    class MinAttributeAggregatorStateFloat
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private Deque<Float> minDeque = null;
        private volatile Float minValue = null;

        public MinAttributeAggregatorStateFloat(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Float>();
            }
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.minDeque != null) {
                Iterator<Float> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next().floatValue() > value.floatValue()) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.isEmpty()) && this.minValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            state.put("MinDeque", this.minDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Float)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }

    class MinAttributeAggregatorStateDouble
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private Deque<Double> minDeque = null;
        private volatile Double minValue = null;

        public MinAttributeAggregatorStateDouble(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Double>();
            }
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.minDeque != null) {
                Iterator<Double> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() > value) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.isEmpty()) && this.minValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            state.put("MinDeque", this.minDeque);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Double)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }
}

