/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.input.source;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.AttributeMapping;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.stream.input.source.SourceHandler;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.core.stream.input.source.SourceSyncCallback;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.StringUtil;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.EmptyStateHolder;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.core.util.transport.BackoffRetryCounter;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Source<S extends State> {
    private static final Logger LOG = LogManager.getLogger(Source.class);
    private String type;
    private SourceMapper mapper;
    private StreamDefinition streamDefinition;
    private SiddhiAppContext siddhiAppContext;
    private AtomicBoolean isTryingToConnect = new AtomicBoolean(false);
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService;
    private ConnectionCallback connectionCallback = new ConnectionCallback();
    private StateHolder<S> stateHolder;
    private S state;
    private ServiceDeploymentInfo serviceDeploymentInfo;

    public final void init(String sourceType, OptionHolder transportOptionHolder, SourceMapper sourceMapper, String[] transportPropertyNames, ConfigReader configReader, String mapType, OptionHolder mapOptionHolder, List<AttributeMapping> attributeMappings, List<AttributeMapping> transportMappings, ConfigReader mapperConfigReader, SourceHandler sourceHandler, StreamDefinition streamDefinition, Map<String, String> deploymentProperties, SiddhiAppContext siddhiAppContext) {
        this.type = sourceType;
        sourceMapper.init(streamDefinition, mapType, mapOptionHolder, attributeMappings, sourceType, this instanceof SourceSyncCallback ? (SourceSyncCallback)((Object)this) : null, transportMappings, sourceHandler, transportOptionHolder, mapperConfigReader, siddhiAppContext);
        this.mapper = sourceMapper;
        this.streamDefinition = streamDefinition;
        this.siddhiAppContext = siddhiAppContext;
        StateFactory<S> stateFactory = this.init(sourceMapper, transportOptionHolder, transportPropertyNames, configReader, siddhiAppContext);
        this.stateHolder = siddhiAppContext.generateStateHolder(streamDefinition.getId() + "-" + this.getClass().getName(), stateFactory);
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
        this.serviceDeploymentInfo = this.exposeServiceDeploymentInfo();
        if (this.serviceDeploymentInfo != null) {
            this.serviceDeploymentInfo.addDeploymentProperties(deploymentProperties);
        } else if (!deploymentProperties.isEmpty()) {
            throw new SiddhiAppCreationException("Deployment properties '" + deploymentProperties + "' are defined for source '" + sourceType + "' which does not expose a service");
        }
    }

    protected abstract ServiceDeploymentInfo exposeServiceDeploymentInfo();

    public abstract StateFactory<S> init(SourceEventListener var1, OptionHolder var2, String[] var3, ConfigReader var4, SiddhiAppContext var5);

    public abstract Class[] getOutputEventClasses();

    public abstract void connect(ConnectionCallback var1, S var2) throws ConnectionUnavailableException;

    public abstract void disconnect();

    public abstract void destroy();

    public abstract void pause();

    public abstract void resume();

    public void connectWithRetry() {
        if (!this.isConnected.get()) {
            this.isTryingToConnect.set(true);
            this.state = this.stateHolder.getState();
            try {
                this.connect(this.connectionCallback, this.state);
                this.isConnected.set(true);
                this.isTryingToConnect.set(false);
                this.backoffRetryCounter.reset();
            }
            catch (ConnectionUnavailableException e) {
                this.disconnectSource();
                this.isConnected.set(false);
                this.retryWithBackoff(e);
            }
            catch (RuntimeException e) {
                LOG.error(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext)) + " Error while connecting at Source '" + StringUtil.removeCRLFCharacters(this.type) + "' at '" + StringUtil.removeCRLFCharacters(this.streamDefinition.getId()) + "'.", (Throwable)e);
                throw e;
            }
        }
    }

    private void retryWithBackoff(ConnectionUnavailableException e) {
        LOG.error(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while connecting at Source '" + StringUtil.removeCRLFCharacters(this.type) + "' at '" + StringUtil.removeCRLFCharacters(this.streamDefinition.getId()) + "'. Will retry in '" + StringUtil.removeCRLFCharacters(this.backoffRetryCounter.getTimeInterval()) + "'.", (Throwable)e);
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                Source.this.connectWithRetry();
            }
        }, this.backoffRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
        this.backoffRetryCounter.increment();
    }

    public final SourceMapper getMapper() {
        return this.mapper;
    }

    public void shutdown() {
        try {
            this.disconnectSource();
            this.destroy();
        }
        finally {
            this.isConnected.set(false);
            this.isTryingToConnect.set(false);
        }
    }

    private void disconnectSource() {
        try {
            this.disconnect();
        }
        finally {
            this.stateHolder.returnState(this.state);
            this.state = null;
        }
    }

    public String getType() {
        return this.type;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public ServiceDeploymentInfo getServiceDeploymentInfo() {
        return this.serviceDeploymentInfo;
    }

    public boolean isStateful() {
        return this.stateHolder != null && !(this.stateHolder instanceof EmptyStateHolder);
    }

    public class ConnectionCallback {
        public void onError(ConnectionUnavailableException e) {
            Source.this.disconnectSource();
            Source.this.isConnected.set(false);
            Source.this.retryWithBackoff(e);
        }
    }
}

