/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.statistics;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.expression.Expression;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReceivedEventCounter
implements Runnable {
    private static final Logger log = LogManager.getLogger(ReceivedEventCounter.class);
    private long totalEventCounter = 0L;
    private long eventCounter = 0L;
    private SiddhiAppContext siddhiAppContext;
    private ScheduledFuture scheduleLogger;
    private StreamDefinition streamDefinition;
    private int duration = 1;
    private long loggerExecutionInterval;

    public void init(SiddhiAppContext siddhiAppContext, StreamDefinition streamDefinition, int duration) {
        this.siddhiAppContext = siddhiAppContext;
        this.streamDefinition = streamDefinition;
        this.duration = duration;
        this.loggerExecutionInterval = Expression.Time.minute((int)duration).value();
    }

    public void countEvents(Object eventObject) {
        if (eventObject instanceof Event[]) {
            this.eventCounter += (long)((Event[])eventObject).length;
            this.totalEventCounter += (long)((Event[])eventObject).length;
        } else {
            ++this.eventCounter;
            ++this.totalEventCounter;
        }
    }

    @Override
    public void run() {
        log.info("Event received for Stream " + this.streamDefinition.getId() + " in siddhi App " + this.siddhiAppContext.getName() + " for last " + this.duration + " minute(s): " + this.eventCounter + ". Total Events: " + this.totalEventCounter + ".");
        this.eventCounter = 0L;
    }

    public void scheduleEventCounterLogger() {
        if (this.scheduleLogger != null) {
            this.scheduleLogger.cancel(true);
        }
        this.scheduleLogger = this.siddhiAppContext.getScheduledExecutorService().scheduleWithFixedDelay(this, this.loggerExecutionInterval, this.loggerExecutionInterval, TimeUnit.MILLISECONDS);
    }
}

