/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.aggregation.AggregationExpressionBuilder;
import io.siddhi.core.aggregation.AggregationExpressionVisitor;
import io.siddhi.core.aggregation.IncrementalDataPurger;
import io.siddhi.core.aggregation.IncrementalExecutor;
import io.siddhi.core.aggregation.IncrementalExecutorsInitialiser;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.QueryableRecordTableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.snapshot.SnapshotService;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.MemoryCalculable;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.aggregation.Within;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.execution.query.selection.OutputAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.AttributeFunction;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.expression.constant.BoolConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class AggregationRuntime
implements MemoryCalculable {
    private static final Logger LOG = Logger.getLogger(AggregationRuntime.class);
    private AggregationDefinition aggregationDefinition;
    private boolean isProcessingOnExternalTime;
    private boolean isDistributed;
    private List<TimePeriod.Duration> incrementalDurations;
    private Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap;
    private Map<TimePeriod.Duration, Table> aggregationTables;
    private List<String> tableAttributesNameList;
    private MetaStreamEvent aggregateMetaSteamEvent;
    private List<ExpressionExecutor> outputExpressionExecutors;
    private Map<TimePeriod.Duration, List<ExpressionExecutor>> aggregateProcessingExecutorsMap;
    private ExpressionExecutor shouldUpdateTimestamp;
    private Map<TimePeriod.Duration, GroupByKeyGenerator> groupByKeyGeneratorMap;
    private boolean isOptimisedLookup;
    private List<OutputAttribute> defaultSelectorList;
    private List<String> groupByVariablesList;
    private boolean isLatestEventColAdded;
    private int baseAggregatorBeginIndex;
    private List<Expression> finalBaseExpressionsList;
    private IncrementalDataPurger incrementalDataPurger;
    private IncrementalExecutorsInitialiser incrementalExecutorsInitialiser;
    private SingleStreamRuntime singleStreamRuntime;
    private LatencyTracker latencyTrackerFind;
    private ThroughputTracker throughputTrackerFind;
    private boolean isFirstEventArrived;

    public AggregationRuntime(AggregationDefinition aggregationDefinition, boolean isProcessingOnExternalTime, boolean isDistributed, List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, Map<TimePeriod.Duration, Table> aggregationTables, List<ExpressionExecutor> outputExpressionExecutors, Map<TimePeriod.Duration, List<ExpressionExecutor>> aggregateProcessingExecutorsMap, ExpressionExecutor shouldUpdateTimestamp, Map<TimePeriod.Duration, GroupByKeyGenerator> groupByKeyGeneratorMap, boolean isOptimisedLookup, List<OutputAttribute> defaultSelectorList, List<String> groupByVariablesList, boolean isLatestEventColAdded, int baseAggregatorBeginIndex, List<Expression> finalBaseExpressionList, IncrementalDataPurger incrementalDataPurger, IncrementalExecutorsInitialiser incrementalExecutorInitialiser, SingleStreamRuntime singleStreamRuntime, MetaStreamEvent tableMetaStreamEvent, LatencyTracker latencyTrackerFind, ThroughputTracker throughputTrackerFind) {
        this.aggregationDefinition = aggregationDefinition;
        this.isProcessingOnExternalTime = isProcessingOnExternalTime;
        this.isDistributed = isDistributed;
        this.incrementalDurations = incrementalDurations;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.aggregationTables = aggregationTables;
        this.tableAttributesNameList = tableMetaStreamEvent.getInputDefinitions().get(0).getAttributeList().stream().map(Attribute::getName).collect(Collectors.toList());
        this.outputExpressionExecutors = outputExpressionExecutors;
        this.aggregateProcessingExecutorsMap = aggregateProcessingExecutorsMap;
        this.shouldUpdateTimestamp = shouldUpdateTimestamp;
        this.groupByKeyGeneratorMap = groupByKeyGeneratorMap;
        this.isOptimisedLookup = isOptimisedLookup;
        this.defaultSelectorList = defaultSelectorList;
        this.groupByVariablesList = groupByVariablesList;
        this.isLatestEventColAdded = isLatestEventColAdded;
        this.baseAggregatorBeginIndex = baseAggregatorBeginIndex;
        this.finalBaseExpressionsList = finalBaseExpressionList;
        this.incrementalDataPurger = incrementalDataPurger;
        this.incrementalExecutorsInitialiser = incrementalExecutorInitialiser;
        this.singleStreamRuntime = singleStreamRuntime;
        this.aggregateMetaSteamEvent = new MetaStreamEvent();
        aggregationDefinition.getAttributeList().forEach(this.aggregateMetaSteamEvent::addOutputData);
        this.latencyTrackerFind = latencyTrackerFind;
        this.throughputTrackerFind = throughputTrackerFind;
    }

    private static void initMetaStreamEvent(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition, String inputReferenceId) {
        metaStreamEvent.addInputDefinition(inputDefinition);
        metaStreamEvent.setInputReferenceId(inputReferenceId);
        metaStreamEvent.initializeAfterWindowData();
        inputDefinition.getAttributeList().forEach(metaStreamEvent::addData);
    }

    private static MetaStreamEvent alterMetaStreamEvent(boolean isStoreQuery, MetaStreamEvent originalMetaStreamEvent, List<Attribute> additionalAttributes) {
        StreamDefinition alteredStreamDef = new StreamDefinition();
        if (!isStoreQuery) {
            for (Attribute attribute2 : originalMetaStreamEvent.getLastInputDefinition().getAttributeList()) {
                alteredStreamDef.attribute(attribute2.getName(), attribute2.getType());
            }
        }
        additionalAttributes.forEach(attribute -> alteredStreamDef.attribute(attribute.getName(), attribute.getType()));
        AggregationRuntime.initMetaStreamEvent(originalMetaStreamEvent, (AbstractDefinition)alteredStreamDef, originalMetaStreamEvent.getInputReferenceId());
        return originalMetaStreamEvent;
    }

    private static MetaStreamEvent createMetaStoreEvent(AbstractDefinition tableDefinition, String referenceId) {
        MetaStreamEvent metaStreamEventForTable = new MetaStreamEvent();
        metaStreamEventForTable.setEventType(MetaStreamEvent.EventType.TABLE);
        AggregationRuntime.initMetaStreamEvent(metaStreamEventForTable, tableDefinition, referenceId);
        return metaStreamEventForTable;
    }

    private static MatchingMetaInfoHolder alterMetaInfoHolderForStoreQuery(MetaStreamEvent newMetaStreamEventWithStartEnd, MatchingMetaInfoHolder matchingMetaInfoHolder) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(2);
        MetaStreamEvent incomingMetaStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(0);
        metaStateEvent.addEvent(newMetaStreamEventWithStartEnd);
        metaStateEvent.addEvent(incomingMetaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, 0, 1, newMetaStreamEventWithStartEnd.getLastInputDefinition(), incomingMetaStreamEvent.getLastInputDefinition(), -1);
    }

    private static MatchingMetaInfoHolder createNewStreamTableMetaInfoHolder(MetaStreamEvent metaStreamEvent, MetaStreamEvent metaStoreEvent) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(2);
        metaStateEvent.addEvent(metaStreamEvent);
        metaStateEvent.addEvent(metaStoreEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, 0, 1, metaStreamEvent.getLastInputDefinition(), metaStoreEvent.getLastInputDefinition(), -1);
    }

    public AggregationDefinition getAggregationDefinition() {
        return this.aggregationDefinition;
    }

    public SingleStreamRuntime getSingleStreamRuntime() {
        return this.singleStreamRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, SiddhiQueryContext siddhiQueryContext) {
        try {
            SnapshotService.getSkipStateStorageThreadLocal().set(true);
            if (this.latencyTrackerFind != null && Level.BASIC.compareTo(siddhiQueryContext.getSiddhiAppContext().getRootMetricsLevel()) <= 0) {
                this.latencyTrackerFind.markIn();
                this.throughputTrackerFind.eventIn();
            }
            if (!this.isDistributed && !this.isFirstEventArrived) {
                this.initialiseExecutors(false);
            }
            StreamEvent streamEvent = ((IncrementalAggregateCompileCondition)compiledCondition).find(matchingEvent, this.incrementalExecutorMap, this.aggregateProcessingExecutorsMap, this.groupByKeyGeneratorMap, this.shouldUpdateTimestamp);
            return streamEvent;
        }
        finally {
            SnapshotService.getSkipStateStorageThreadLocal().set(null);
            if (this.latencyTrackerFind != null && Level.BASIC.compareTo(siddhiQueryContext.getSiddhiAppContext().getRootMetricsLevel()) <= 0) {
                this.latencyTrackerFind.markOut();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompiledCondition compileExpression(Expression expression, Within within, Expression per, List<Variable> queryGroupByList, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor perExpressionExecutor;
        MetaStreamEvent metaStreamEventForTableLookups;
        boolean isStoreQuery;
        String aggregationName = this.aggregationDefinition.getId();
        boolean isOptimisedTableLookup = this.isOptimisedLookup;
        HashMap<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions = new HashMap<TimePeriod.Duration, CompiledCondition>();
        ArrayList<Attribute> additionalAttributes = new ArrayList<Attribute>();
        additionalAttributes.add(new Attribute("_START", Attribute.Type.LONG));
        additionalAttributes.add(new Attribute("_END", Attribute.Type.LONG));
        int lowerGranularitySize = this.incrementalDurations.size() - 1;
        ArrayList<String> lowerGranularityAttributes = new ArrayList<String>();
        if (this.isDistributed) {
            for (int i = 0; i < lowerGranularitySize; ++i) {
                String attributeName = "_AGG_TIMESTAMP_FILTER_" + i;
                additionalAttributes.add(new Attribute(attributeName, Attribute.Type.LONG));
                lowerGranularityAttributes.add(attributeName);
            }
        }
        TableDefinition tableDefinition = this.aggregationTables.get(this.incrementalDurations.get(0)).getTableDefinition();
        boolean bl = isStoreQuery = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents().length == 1;
        if (isStoreQuery) {
            metaStreamEventForTableLookups = AggregationRuntime.alterMetaStreamEvent(true, new MetaStreamEvent(), additionalAttributes);
            matchingMetaInfoHolder = AggregationRuntime.alterMetaInfoHolderForStoreQuery(metaStreamEventForTableLookups, matchingMetaInfoHolder);
        } else {
            metaStreamEventForTableLookups = AggregationRuntime.alterMetaStreamEvent(false, matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(0), additionalAttributes);
        }
        String aggReferenceId = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(1).getInputReferenceId();
        MetaStreamEvent metaStoreEventForTableLookups = AggregationRuntime.createMetaStoreEvent((AbstractDefinition)tableDefinition, aggReferenceId);
        MatchingMetaInfoHolder metaInfoHolderForTableLookups = AggregationRuntime.createNewStreamTableMetaInfoHolder(metaStreamEventForTableLookups, metaStoreEventForTableLookups);
        if (per != null) {
            perExpressionExecutor = ExpressionParser.parseExpression(per, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            if (perExpressionExecutor.getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppCreationException("Query " + siddhiQueryContext.getName() + "'s per value expected a string but found " + perExpressionExecutor.getReturnType(), per.getQueryContextStartIndex(), per.getQueryContextEndIndex());
            }
            if (perExpressionExecutor instanceof ConstantExpressionExecutor) {
                String perValue = ((ConstantExpressionExecutor)perExpressionExecutor).getValue().toString();
                try {
                    Expression.Time.normalizeDuration((String)perValue);
                }
                catch (SiddhiAppValidationException e) {
                    throw new SiddhiAppValidationException("Aggregation Query's per value is expected to be of a valid time function of the following " + TimePeriod.Duration.SECONDS + ", " + TimePeriod.Duration.MINUTES + ", " + TimePeriod.Duration.HOURS + ", " + TimePeriod.Duration.DAYS + ", " + TimePeriod.Duration.MONTHS + ", " + TimePeriod.Duration.YEARS + ".");
                }
            }
        } else {
            throw new SiddhiAppCreationException("Syntax Error: Aggregation join query must contain a `per` definition for granularity");
        }
        if (within == null) {
            throw new SiddhiAppCreationException("Syntax Error : Aggregation read query must contain a `within` definition for filtering of aggregation data.");
        }
        AttributeFunction startEndTimeExpression = within.getTimeRange().size() == 1 ? new AttributeFunction("incrementalAggregator", "startTimeEndTime", new Expression[]{(Expression)within.getTimeRange().get(0)}) : new AttributeFunction("incrementalAggregator", "startTimeEndTime", new Expression[]{(Expression)within.getTimeRange().get(0), (Expression)within.getTimeRange().get(1)});
        ExpressionExecutor startTimeEndTimeExpressionExecutor = ExpressionParser.parseExpression((Expression)startEndTimeExpression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
        Variable timeFilterExpression = this.isProcessingOnExternalTime ? Expression.variable((String)"AGG_EVENT_TIMESTAMP") : Expression.variable((String)"AGG_TIMESTAMP");
        Variable start = Expression.variable((String)((Attribute)additionalAttributes.get(0)).getName());
        Variable end = Expression.variable((String)((Attribute)additionalAttributes.get(1)).getName());
        Expression compareWithStartTime = Compare.compare((Expression)start, (Compare.Operator)Compare.Operator.LESS_THAN_EQUAL, (Expression)timeFilterExpression);
        Expression compareWithEndTime = Compare.compare((Expression)timeFilterExpression, (Compare.Operator)Compare.Operator.LESS_THAN, (Expression)end);
        Expression withinExpression = Expression.and((Expression)compareWithStartTime, (Expression)compareWithEndTime);
        ArrayList<ExpressionExecutor> timestampFilterExecutors = new ArrayList<ExpressionExecutor>();
        if (this.isDistributed) {
            for (int i = 0; i < lowerGranularitySize; ++i) {
                Expression[] expressionArray = new Expression[]{new AttributeFunction("", "currentTimeMillis", null), Expression.value((String)this.incrementalDurations.get(i + 1).toString())};
                AttributeFunction filterExpression = new AttributeFunction("incrementalAggregator", "getAggregationStartTime", expressionArray);
                timestampFilterExecutors.add(ExpressionParser.parseExpression((Expression)filterExpression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext));
            }
        }
        boolean shouldApplyReducedCondition = false;
        Expression reducedExpression = null;
        if (!(expression instanceof BoolConstant)) {
            AggregationExpressionBuilder aggregationExpressionBuilder = new AggregationExpressionBuilder(expression);
            AggregationExpressionVisitor expressionVisitor = new AggregationExpressionVisitor(metaStreamEventForTableLookups.getInputReferenceId(), metaStreamEventForTableLookups.getLastInputDefinition().getAttributeList(), this.tableAttributesNameList);
            aggregationExpressionBuilder.build(expressionVisitor);
            shouldApplyReducedCondition = expressionVisitor.applyReducedExpression();
            reducedExpression = expressionVisitor.getReducedExpression();
        }
        Expression withinExpressionTable = shouldApplyReducedCondition ? Expression.and((Expression)withinExpression, reducedExpression) : withinExpression;
        Variable timestampVariable = new Variable("AGG_TIMESTAMP");
        List queryGroupByNamesList = queryGroupByList.stream().map(Variable::getAttributeName).collect(Collectors.toList());
        boolean queryGroupByContainsTimestamp = queryGroupByNamesList.remove("AGG_TIMESTAMP");
        boolean isQueryGroupBySameAsAggGroupBy = queryGroupByList.isEmpty() || queryGroupByList.contains(timestampVariable) && queryGroupByNamesList.equals(this.groupByVariablesList);
        ArrayList<VariableExpressionExecutor> variableExpExecutorsForTableLookups = new ArrayList<VariableExpressionExecutor>();
        HashMap<TimePeriod.Duration, CompiledSelection> withinTableCompiledSelection = new HashMap<TimePeriod.Duration, CompiledSelection>();
        if (isOptimisedTableLookup) {
            Selector selector = Selector.selector();
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            if (!isQueryGroupBySameAsAggGroupBy) {
                if (queryGroupByContainsTimestamp) {
                    if (this.isProcessingOnExternalTime) {
                        arrayList.add(new Variable("AGG_EVENT_TIMESTAMP"));
                    } else {
                        arrayList.add(new Variable("AGG_TIMESTAMP"));
                    }
                    queryGroupByList.remove(timestampVariable);
                }
                for (Variable variable : queryGroupByList) {
                    String referenceId = variable.getStreamId();
                    if (aggReferenceId == null) {
                        if (!this.tableAttributesNameList.contains(variable.getAttributeName())) continue;
                        arrayList.add(variable);
                        continue;
                    }
                    if (!aggReferenceId.equalsIgnoreCase(referenceId)) continue;
                    arrayList.add(variable);
                }
                if (arrayList.isEmpty()) {
                    isQueryGroupBySameAsAggGroupBy = true;
                }
            }
            if (aggReferenceId != null) {
                arrayList.forEach(groupBy -> groupBy.setStreamId(aggReferenceId));
            }
            selector.addGroupByList(arrayList);
            List<OutputAttribute> selectorList = !isQueryGroupBySameAsAggGroupBy ? AggregationRuntime.constructSelectorList(this.isProcessingOnExternalTime, this.isDistributed, this.isLatestEventColAdded, this.baseAggregatorBeginIndex, this.groupByVariablesList.size(), this.finalBaseExpressionsList, (AbstractDefinition)tableDefinition, arrayList) : this.defaultSelectorList;
            if (aggReferenceId != null) {
                for (OutputAttribute outputAttribute : selectorList) {
                    if (outputAttribute.getExpression() instanceof Variable) {
                        ((Variable)outputAttribute.getExpression()).setStreamId(aggReferenceId);
                        continue;
                    }
                    for (Expression parameter : ((AttributeFunction)outputAttribute.getExpression()).getParameters()) {
                        ((Variable)parameter).setStreamId(aggReferenceId);
                    }
                }
            }
            selector.addSelectionList(selectorList);
            try {
                this.aggregationTables.entrySet().forEach(arg_0 -> AggregationRuntime.lambda$compileExpression$2(selector, (AbstractDefinition)tableDefinition, metaInfoHolderForTableLookups, variableExpExecutorsForTableLookups, tableMap, siddhiQueryContext, withinTableCompiledSelection, arg_0));
            }
            catch (QueryableRecordTableException | SiddhiAppCreationException | SiddhiAppValidationException throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Aggregation Query optimization failed for aggregation: '" + aggregationName + "'. Creating table lookup query in normal mode. Reason for failure: " + throwable.getMessage()), throwable);
                }
                isOptimisedTableLookup = false;
            }
        }
        for (Map.Entry entry : this.aggregationTables.entrySet()) {
            CompiledCondition withinTableCompileCondition = ((Table)entry.getValue()).compileCondition(withinExpressionTable, metaInfoHolderForTableLookups, variableExpExecutorsForTableLookups, tableMap, siddhiQueryContext);
            withinTableCompiledConditions.put((TimePeriod.Duration)entry.getKey(), withinTableCompileCondition);
        }
        Operator withinInMemoryCompileCondition = OperatorParser.constructOperator(new ComplexEventChunk(true), withinExpression, metaInfoHolderForTableLookups, variableExpExecutorsForTableLookups, tableMap, siddhiQueryContext);
        HashMap<TimePeriod.Duration, CompiledCondition> withinTableLowerGranularityCompileCondition = new HashMap<TimePeriod.Duration, CompiledCondition>();
        if (this.isDistributed) {
            for (int i = 0; i < lowerGranularitySize; ++i) {
                void var43_51;
                if (this.isProcessingOnExternalTime) {
                    Expression expression2 = Expression.and((Expression)Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.variable((String)((String)lowerGranularityAttributes.get(i)))), (Expression)withinExpressionTable);
                } else if (shouldApplyReducedCondition) {
                    Expression expression3 = Expression.and((Expression)Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.variable((String)((String)lowerGranularityAttributes.get(i)))), (Expression)reducedExpression);
                } else {
                    Expression expression4 = Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.variable((String)((String)lowerGranularityAttributes.get(i))));
                }
                TimePeriod.Duration duration = this.incrementalDurations.get(i);
                String tableName = aggregationName + "_" + duration.toString();
                CompiledCondition compiledCondition = tableMap.get(tableName).compileCondition((Expression)var43_51, metaInfoHolderForTableLookups, variableExpExecutorsForTableLookups, tableMap, siddhiQueryContext);
                withinTableLowerGranularityCompileCondition.put(duration, compiledCondition);
            }
        }
        QueryParserHelper.reduceMetaComplexEvent(metaInfoHolderForTableLookups.getMetaStateEvent());
        Operator onCompiledCondition = OperatorParser.constructOperator(new ComplexEventChunk(true), expression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        return new IncrementalAggregateCompileCondition(isStoreQuery, aggregationName, this.isProcessingOnExternalTime, this.isDistributed, this.incrementalDurations, this.aggregationTables, this.outputExpressionExecutors, isOptimisedTableLookup, withinTableCompiledSelection, withinTableCompiledConditions, withinInMemoryCompileCondition, withinTableLowerGranularityCompileCondition, onCompiledCondition, additionalAttributes, perExpressionExecutor, startTimeEndTimeExpressionExecutor, timestampFilterExecutors, this.aggregateMetaSteamEvent, matchingMetaInfoHolder, metaInfoHolderForTableLookups, variableExpExecutorsForTableLookups);
    }

    private static List<OutputAttribute> constructSelectorList(boolean isProcessingOnExternalTime, boolean isDistributed, boolean isLatestEventColAdded, int baseAggregatorBeginIndex, int numGroupByVariables, List<Expression> finalBaseExpressions, AbstractDefinition incomingOutputStreamDefinition, List<Variable> newGroupByList) {
        ArrayList<OutputAttribute> selectorList = new ArrayList<OutputAttribute>();
        List attributeList = incomingOutputStreamDefinition.getAttributeList();
        List queryGroupByNames = newGroupByList.stream().map(Variable::getAttributeName).collect(Collectors.toList());
        Variable maxVariable = !isProcessingOnExternalTime ? new Variable("AGG_TIMESTAMP") : (isLatestEventColAdded ? new Variable("AGG_LAST_EVENT_TIMESTAMP") : new Variable("AGG_EVENT_TIMESTAMP"));
        int i = 0;
        OutputAttribute timestampAttribute = !isProcessingOnExternalTime && queryGroupByNames.contains("AGG_TIMESTAMP") ? new OutputAttribute(new Variable("AGG_TIMESTAMP")) : new OutputAttribute(((Attribute)attributeList.get(i)).getName(), Expression.function((String)"max", (Expression[])new Expression[]{new Variable("AGG_TIMESTAMP")}));
        selectorList.add(timestampAttribute);
        ++i;
        if (isDistributed) {
            selectorList.add(new OutputAttribute("SHARD_ID", Expression.function((String)"max", (Expression[])new Expression[]{new Variable("SHARD_ID")})));
            ++i;
        }
        if (isProcessingOnExternalTime) {
            OutputAttribute externalTimestampAttribute = queryGroupByNames.contains("AGG_TIMESTAMP") ? new OutputAttribute(new Variable("AGG_EVENT_TIMESTAMP")) : new OutputAttribute(((Attribute)attributeList.get(i)).getName(), Expression.function((String)"max", (Expression[])new Expression[]{new Variable("AGG_EVENT_TIMESTAMP")}));
            selectorList.add(externalTimestampAttribute);
            ++i;
        }
        for (int j = 0; j < numGroupByVariables; ++j) {
            Variable variable = new Variable(((Attribute)attributeList.get(i)).getName());
            OutputAttribute groupByAttribute = queryGroupByNames.contains(variable.getAttributeName()) ? new OutputAttribute(variable) : new OutputAttribute(variable.getAttributeName(), Expression.function((String)"incrementalAggregator", (String)"last", (Expression[])new Expression[]{new Variable(((Attribute)attributeList.get(i)).getName()), maxVariable}));
            selectorList.add(groupByAttribute);
            ++i;
        }
        if (isLatestEventColAdded) {
            --baseAggregatorBeginIndex;
        }
        while (i < baseAggregatorBeginIndex) {
            Variable variable = new Variable(((Attribute)attributeList.get(i)).getName());
            OutputAttribute outputAttribute = queryGroupByNames.contains(variable.getAttributeName()) ? new OutputAttribute(variable) : new OutputAttribute(((Attribute)attributeList.get(i)).getName(), Expression.function((String)"incrementalAggregator", (String)"last", (Expression[])new Expression[]{new Variable(((Attribute)attributeList.get(i)).getName()), maxVariable}));
            selectorList.add(outputAttribute);
            ++i;
        }
        if (isLatestEventColAdded) {
            OutputAttribute lastTimestampAttribute = new OutputAttribute("AGG_LAST_EVENT_TIMESTAMP", Expression.function((String)"max", (Expression[])new Expression[]{new Variable("AGG_LAST_EVENT_TIMESTAMP")}));
            selectorList.add(lastTimestampAttribute);
            ++i;
        }
        for (Expression finalBaseExpression : finalBaseExpressions) {
            OutputAttribute outputAttribute = new OutputAttribute(((Attribute)attributeList.get(i)).getName(), finalBaseExpression);
            selectorList.add(outputAttribute);
            ++i;
        }
        return selectorList;
    }

    public void startPurging() {
        this.incrementalDataPurger.executeIncrementalDataPurging();
    }

    public void initialiseExecutors(boolean isFirstEventArrived) {
        if (isFirstEventArrived) {
            this.isFirstEventArrived = true;
            for (Map.Entry<TimePeriod.Duration, IncrementalExecutor> durationIncrementalExecutorEntry : this.incrementalExecutorMap.entrySet()) {
                durationIncrementalExecutorEntry.getValue().setProcessingExecutor(true);
            }
        }
        this.incrementalExecutorsInitialiser.initialiseExecutors();
    }

    public void processEvents(ComplexEventChunk<StreamEvent> streamEventComplexEventChunk) {
        this.incrementalExecutorMap.get(this.incrementalDurations.get(0)).execute(streamEventComplexEventChunk);
    }

    private static /* synthetic */ void lambda$compileExpression$2(Selector selector, AbstractDefinition tableDefinition, MatchingMetaInfoHolder metaInfoHolderForTableLookups, List variableExpExecutorsForTableLookups, Map tableMap, SiddhiQueryContext siddhiQueryContext, Map withinTableCompiledSelection, Map.Entry durationTableEntry) {
        CompiledSelection compiledSelection = ((QueryableProcessor)durationTableEntry.getValue()).compileSelection(selector, tableDefinition.getAttributeList(), metaInfoHolderForTableLookups, variableExpExecutorsForTableLookups, tableMap, siddhiQueryContext);
        withinTableCompiledSelection.put(durationTableEntry.getKey(), compiledSelection);
    }
}

