/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.debugger.SiddhiDebugger;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.event.stream.converter.StreamEventConverterFactory;
import io.siddhi.core.query.input.stream.state.PreStateProcessor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import java.util.ArrayList;
import java.util.List;

public class ProcessStreamReceiver
implements StreamJunction.Receiver {
    protected final SiddhiQueryContext siddhiQueryContext;
    protected String streamId;
    protected Processor next;
    protected List<PreStateProcessor> stateProcessorsForStream = new ArrayList<PreStateProcessor>();
    protected int stateProcessorsForStreamSize;
    protected LockWrapper lockWrapper;
    protected boolean batchProcessingAllowed;
    private StreamEventConverter streamEventConverter;
    private MetaStreamEvent metaStreamEvent;
    private StreamEventFactory streamEventFactory;
    private SiddhiDebugger siddhiDebugger;
    protected List<PreStateProcessor> allStateProcessors = new ArrayList<PreStateProcessor>();
    protected int allStateProcessorsSize;

    public ProcessStreamReceiver(String streamId, SiddhiQueryContext siddhiQueryContext) {
        this.streamId = streamId;
        this.siddhiQueryContext = siddhiQueryContext;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    public void setSiddhiDebugger(SiddhiDebugger siddhiDebugger) {
        this.siddhiDebugger = siddhiDebugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(ComplexEventChunk<StreamEvent> streamEventChunk) {
        block9: {
            if (this.lockWrapper != null) {
                this.lockWrapper.lock();
            }
            try {
                LatencyTracker latencyTracker = this.siddhiQueryContext.getLatencyTracker();
                if (Level.BASIC.compareTo(this.siddhiQueryContext.getSiddhiAppContext().getRootMetricsLevel()) <= 0 && latencyTracker != null) {
                    try {
                        latencyTracker.markIn();
                        this.processAndClear(streamEventChunk);
                        break block9;
                    }
                    finally {
                        latencyTracker.markOut();
                    }
                }
                this.processAndClear(streamEventChunk);
            }
            finally {
                if (this.lockWrapper != null) {
                    this.lockWrapper.unlock();
                }
            }
        }
    }

    @Override
    public void receive(ComplexEvent complexEvents) {
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.siddhiQueryContext.getName(), SiddhiDebugger.QueryTerminal.IN, complexEvents);
        }
        StreamEvent firstEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertComplexEvent(complexEvents, firstEvent);
        StreamEvent currentEvent = firstEvent;
        for (complexEvents = complexEvents.getNext(); complexEvents != null; complexEvents = complexEvents.getNext()) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.streamEventConverter.convertComplexEvent(complexEvents, nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        this.process(new ComplexEventChunk<StreamEvent>(firstEvent, currentEvent, this.batchProcessingAllowed));
    }

    @Override
    public void receive(Event event) {
        if (event != null) {
            StreamEvent newEvent = this.streamEventFactory.newInstance();
            this.streamEventConverter.convertEvent(event, newEvent);
            if (this.siddhiDebugger != null) {
                this.siddhiDebugger.checkBreakPoint(this.siddhiQueryContext.getName(), SiddhiDebugger.QueryTerminal.IN, newEvent);
            }
            this.process(new ComplexEventChunk<StreamEvent>(newEvent, newEvent, this.batchProcessingAllowed));
        }
    }

    @Override
    public void receive(Event[] events) {
        StreamEvent firstEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertEvent(events[0], firstEvent);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.length;
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.streamEventConverter.convertEvent(events[i], nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.siddhiQueryContext.getName(), SiddhiDebugger.QueryTerminal.IN, firstEvent);
        }
        this.process(new ComplexEventChunk<StreamEvent>(firstEvent, currentEvent, this.batchProcessingAllowed));
    }

    @Override
    public void receive(List<Event> events) {
        StreamEvent firstEvent = null;
        StreamEvent currentEvent = null;
        for (Event event : events) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.streamEventConverter.convertEvent(event, nextEvent);
            if (firstEvent == null) {
                firstEvent = nextEvent;
            } else {
                currentEvent.setNext(nextEvent);
            }
            currentEvent = nextEvent;
        }
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.siddhiQueryContext.getName(), SiddhiDebugger.QueryTerminal.IN, firstEvent);
        }
        this.process(new ComplexEventChunk<Object>(firstEvent, currentEvent, this.batchProcessingAllowed));
    }

    @Override
    public void receive(long timestamp, Object[] data) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertData(timestamp, data, newEvent);
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.siddhiQueryContext.getName(), SiddhiDebugger.QueryTerminal.IN, newEvent);
        }
        this.process(new ComplexEventChunk<StreamEvent>(newEvent, newEvent, this.batchProcessingAllowed));
    }

    protected void processAndClear(ComplexEventChunk<StreamEvent> streamEventChunk) {
        this.next.process(streamEventChunk);
        streamEventChunk.clear();
    }

    public void setMetaStreamEvent(MetaStreamEvent metaStreamEvent) {
        this.metaStreamEvent = metaStreamEvent;
    }

    public boolean toStream() {
        return this.metaStreamEvent.getEventType() == MetaStreamEvent.EventType.DEFAULT || this.metaStreamEvent.getEventType() == MetaStreamEvent.EventType.WINDOW;
    }

    public void setBatchProcessingAllowed(boolean batchProcessingAllowed) {
        this.batchProcessingAllowed = batchProcessingAllowed;
    }

    public void setNext(Processor next) {
        this.next = next;
    }

    public void setStreamEventFactory(StreamEventFactory streamEventFactory) {
        this.streamEventFactory = streamEventFactory;
    }

    public void setLockWrapper(LockWrapper lockWrapper) {
        this.lockWrapper = lockWrapper;
    }

    public void init() {
        this.streamEventConverter = StreamEventConverterFactory.constructEventConverter(this.metaStreamEvent);
    }

    public void addStatefulProcessorForStream(PreStateProcessor stateProcessor) {
        this.stateProcessorsForStream.add(stateProcessor);
        this.stateProcessorsForStreamSize = this.stateProcessorsForStream.size();
    }

    public void setAllStatefulProcessors(List<PreStateProcessor> allStateProcessors) {
        this.allStateProcessors = allStateProcessors;
        this.allStateProcessorsSize = allStateProcessors.size();
    }
}

