/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.event;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.HashMap;
import java.util.Map;

public class FirstGroupByPerEventOutputRateLimiter
extends OutputRateLimiter<RateLimiterState> {
    private final Integer value;

    public FirstGroupByPerEventOutputRateLimiter(String id, Integer value) {
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ComplexEventChunk<GroupedComplexEvent> outputEventChunk = new ComplexEventChunk<GroupedComplexEvent>(complexEventChunk.isBatch());
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                while (complexEventChunk.hasNext()) {
                    Object event = complexEventChunk.next();
                    complexEventChunk.remove();
                    GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)event;
                    Integer count = (Integer)state.groupByOutputTime.get(groupedComplexEvent.getGroupKey());
                    if (count == null) {
                        state.groupByOutputTime.put(groupedComplexEvent.getGroupKey(), 1);
                        outputEventChunk.add(groupedComplexEvent);
                        continue;
                    }
                    if (count.equals(this.value - 1)) {
                        state.groupByOutputTime.remove(groupedComplexEvent.getGroupKey());
                        continue;
                    }
                    state.groupByOutputTime.put(groupedComplexEvent.getGroupKey(), count + 1);
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        if (outputEventChunk.getFirst() != null) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void partitionCreated() {
    }

    class RateLimiterState
    extends State {
        private Map<String, Integer> groupByOutputTime = new HashMap<String, Integer>();

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.groupByOutputTime.isEmpty();
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("GroupByOutputTime", this.groupByOutputTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.groupByOutputTime = (Map)state.get("GroupByOutputTime");
        }
    }
}

