/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="avg", namespace="", description="Calculates the average for all the events.", parameters={@Parameter(name="arg", description="The value that need to be averaged.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returns the calculated average value as a double.", type={DataType.DOUBLE})}, examples={@Example(syntax="from fooStream#window.timeBatch\n select avg(temp) as avgTemp\n insert into barStream;", description="avg(temp) returns the average temp value for all the events based on their arrival and expiry.")})
public class AvgAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<AvgAttributeState> {
    private Attribute.Type returnType;

    @Override
    protected StateFactory<AvgAttributeState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Avg aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        this.returnType = Attribute.Type.DOUBLE;
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        return () -> {
            switch (type) {
                case FLOAT: {
                    return new AvgAttributeAggregatorStateFloat();
                }
                case INT: {
                    return new AvgAttributeAggregatorStateInt();
                }
                case LONG: {
                    return new AvgAttributeAggregatorStateLong();
                }
                case DOUBLE: {
                    return new AvgAttributeAggregatorStateDouble();
                }
            }
            throw new OperationNotSupportedException("Avg not supported for " + this.returnType);
        };
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object processAdd(Object data, AvgAttributeState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data, AvgAttributeState state) {
        return new IllegalStateException("Avg cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, AvgAttributeState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data, AvgAttributeState state) {
        return new IllegalStateException("Avg cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(AvgAttributeState state) {
        return state.reset();
    }

    abstract class AvgAttributeState
    extends State {
        AvgAttributeState() {
        }

        public abstract Object processAdd(Object var1);

        public abstract Object processRemove(Object var1);

        public abstract Object reset();

        protected abstract Object currentValue();
    }

    class AvgAttributeAggregatorStateLong
    extends AvgAttributeState {
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorStateLong() {
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Long)data).longValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Long)obj).longValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }

    class AvgAttributeAggregatorStateInt
    extends AvgAttributeState {
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorStateInt() {
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Integer)data).intValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Integer)obj).intValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }

    class AvgAttributeAggregatorStateFloat
    extends AvgAttributeState {
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorStateFloat() {
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Float)data).floatValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Float)obj).floatValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }

    class AvgAttributeAggregatorStateDouble
    extends AvgAttributeState {
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorStateDouble() {
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += ((Double)data).doubleValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= ((Double)obj).doubleValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }
}

