/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.executor;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import io.siddhi.core.util.collection.executor.ExhaustiveCollectionExecutor;
import java.util.Collection;
import java.util.HashSet;

public class NotCollectionExecutor
implements CollectionExecutor {
    private final CollectionExecutor notCollectionExecutor;
    private final ExhaustiveCollectionExecutor exhaustiveCollectionExecutor;

    public NotCollectionExecutor(CollectionExecutor notCollectionExecutor, ExhaustiveCollectionExecutor exhaustiveCollectionExecutor) {
        this.notCollectionExecutor = notCollectionExecutor;
        this.exhaustiveCollectionExecutor = exhaustiveCollectionExecutor;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        Collection<StreamEvent> notStreamEvents = this.notCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (notStreamEvents == null) {
            return this.exhaustiveCollectionExecutor.find(matchingEvent, indexedEventHolder, storeEventCloner);
        }
        if (notStreamEvents.size() == 0) {
            ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
            Collection<StreamEvent> storeEventSet = indexedEventHolder.getAllEvents();
            for (StreamEvent storeEvent : storeEventSet) {
                if (storeEventCloner != null) {
                    returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                    continue;
                }
                returnEventChunk.add(storeEvent);
            }
            return (StreamEvent)returnEventChunk.getFirst();
        }
        Collection<StreamEvent> allEvents = indexedEventHolder.getAllEvents();
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        for (StreamEvent aEvent : allEvents) {
            if (notStreamEvents.contains(aEvent)) continue;
            if (storeEventCloner != null) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(aEvent));
                continue;
            }
            returnEventChunk.add(aEvent);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> notStreamEvents = this.notCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (notStreamEvents == null) {
            return null;
        }
        if (notStreamEvents.size() == 0) {
            return indexedEventHolder.getAllEvents();
        }
        Collection<StreamEvent> allEvents = indexedEventHolder.getAllEvents();
        HashSet<StreamEvent> returnSet = new HashSet<StreamEvent>();
        for (StreamEvent aEvent : allEvents) {
            if (notStreamEvents.contains(aEvent)) continue;
            returnSet.add(aEvent);
        }
        return returnSet;
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> notStreamEvents = this.notCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (notStreamEvents == null) {
            return this.exhaustiveCollectionExecutor.contains(matchingEvent, indexedEventHolder);
        }
        return notStreamEvents.size() != indexedEventHolder.getAllEvents().size();
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> notStreamEvents = this.notCollectionExecutor.findEvents(deletingEvent, indexedEventHolder);
        if (notStreamEvents == null) {
            this.exhaustiveCollectionExecutor.delete(deletingEvent, indexedEventHolder);
        } else if (notStreamEvents.size() == 0) {
            indexedEventHolder.deleteAll();
        } else if (notStreamEvents.size() != indexedEventHolder.getAllEvents().size()) {
            Collection<StreamEvent> allEvents = indexedEventHolder.getAllEvents();
            HashSet<StreamEvent> returnSet = new HashSet<StreamEvent>();
            for (StreamEvent aEvent : allEvents) {
                if (notStreamEvents.contains(aEvent)) continue;
                returnSet.add(aEvent);
            }
            indexedEventHolder.deleteAll(returnSet);
        }
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        if (this.notCollectionExecutor.getDefaultCost() == CollectionExecutor.Cost.EXHAUSTIVE) {
            return CollectionExecutor.Cost.EXHAUSTIVE;
        }
        return CollectionExecutor.Cost.MULTI_RETURN_INDEX_MATCHING;
    }
}

