/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;

public final class CircuitBreakerConfigImpl
implements CircuitBreakerConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final CircuitBreaker instance;
    private final boolean onMethod;
    private Class<? extends Throwable>[] _failOn;
    private Class<? extends Throwable>[] _skipOn;
    private Long _delay;
    private ChronoUnit _delayUnit;
    private Integer _requestVolumeThreshold;
    private Double _failureRatio;
    private Integer _successThreshold;

    private CircuitBreakerConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.circuitBreaker;
        this.onMethod = method.annotationsPresentDirectly.contains(CircuitBreaker.class);
    }

    public static CircuitBreakerConfigImpl create(FaultToleranceMethod method) {
        if (method.circuitBreaker == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(CircuitBreaker.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new CircuitBreakerConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return CircuitBreaker.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<? extends Throwable>[] failOn() {
        if (this._failOn == null) {
            Config config = ConfigProvider.getConfig();
            this._failOn = this.onMethod ? (Class[])config.getOptionalValue(this.getConfigKeyForMethod("failOn"), Class[].class).orElse(null) : (Class[])config.getOptionalValue(this.getConfigKeyForClass("failOn"), Class[].class).orElse(null);
            if (this._failOn == null) {
                this._failOn = config.getOptionalValue("CircuitBreaker/failOn", Class[].class).orElse(null);
            }
            if (this._failOn == null) {
                this._failOn = this.instance.failOn();
            }
        }
        return this._failOn;
    }

    public Class<? extends Throwable>[] skipOn() {
        if (this._skipOn == null) {
            Config config = ConfigProvider.getConfig();
            this._skipOn = this.onMethod ? (Class[])config.getOptionalValue(this.getConfigKeyForMethod("skipOn"), Class[].class).orElse(null) : (Class[])config.getOptionalValue(this.getConfigKeyForClass("skipOn"), Class[].class).orElse(null);
            if (this._skipOn == null) {
                this._skipOn = config.getOptionalValue("CircuitBreaker/skipOn", Class[].class).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = this.instance.skipOn();
            }
        }
        return this._skipOn;
    }

    public long delay() {
        if (this._delay == null) {
            Config config = ConfigProvider.getConfig();
            this._delay = this.onMethod ? (Long)config.getOptionalValue(this.getConfigKeyForMethod("delay"), Long.TYPE).orElse(null) : (Long)config.getOptionalValue(this.getConfigKeyForClass("delay"), Long.TYPE).orElse(null);
            if (this._delay == null) {
                this._delay = config.getOptionalValue("CircuitBreaker/delay", Long.TYPE).orElse(null);
            }
            if (this._delay == null) {
                this._delay = this.instance.delay();
            }
        }
        return this._delay;
    }

    public ChronoUnit delayUnit() {
        if (this._delayUnit == null) {
            Config config = ConfigProvider.getConfig();
            this._delayUnit = this.onMethod ? (ChronoUnit)config.getOptionalValue(this.getConfigKeyForMethod("delayUnit"), ChronoUnit.class).orElse(null) : (ChronoUnit)config.getOptionalValue(this.getConfigKeyForClass("delayUnit"), ChronoUnit.class).orElse(null);
            if (this._delayUnit == null) {
                this._delayUnit = config.getOptionalValue("CircuitBreaker/delayUnit", ChronoUnit.class).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = this.instance.delayUnit();
            }
        }
        return this._delayUnit;
    }

    public int requestVolumeThreshold() {
        if (this._requestVolumeThreshold == null) {
            Config config = ConfigProvider.getConfig();
            this._requestVolumeThreshold = this.onMethod ? (Integer)config.getOptionalValue(this.getConfigKeyForMethod("requestVolumeThreshold"), Integer.TYPE).orElse(null) : (Integer)config.getOptionalValue(this.getConfigKeyForClass("requestVolumeThreshold"), Integer.TYPE).orElse(null);
            if (this._requestVolumeThreshold == null) {
                this._requestVolumeThreshold = config.getOptionalValue("CircuitBreaker/requestVolumeThreshold", Integer.TYPE).orElse(null);
            }
            if (this._requestVolumeThreshold == null) {
                this._requestVolumeThreshold = this.instance.requestVolumeThreshold();
            }
        }
        return this._requestVolumeThreshold;
    }

    public double failureRatio() {
        if (this._failureRatio == null) {
            Config config = ConfigProvider.getConfig();
            this._failureRatio = this.onMethod ? (Double)config.getOptionalValue(this.getConfigKeyForMethod("failureRatio"), Double.TYPE).orElse(null) : (Double)config.getOptionalValue(this.getConfigKeyForClass("failureRatio"), Double.TYPE).orElse(null);
            if (this._failureRatio == null) {
                this._failureRatio = config.getOptionalValue("CircuitBreaker/failureRatio", Double.TYPE).orElse(null);
            }
            if (this._failureRatio == null) {
                this._failureRatio = this.instance.failureRatio();
            }
        }
        return this._failureRatio;
    }

    public int successThreshold() {
        if (this._successThreshold == null) {
            Config config = ConfigProvider.getConfig();
            this._successThreshold = this.onMethod ? (Integer)config.getOptionalValue(this.getConfigKeyForMethod("successThreshold"), Integer.TYPE).orElse(null) : (Integer)config.getOptionalValue(this.getConfigKeyForClass("successThreshold"), Integer.TYPE).orElse(null);
            if (this._successThreshold == null) {
                this._successThreshold = config.getOptionalValue("CircuitBreaker/successThreshold", Integer.TYPE).orElse(null);
            }
            if (this._successThreshold == null) {
                this._successThreshold = this.instance.successThreshold();
            }
        }
        return this._successThreshold;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/CircuitBreaker/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/CircuitBreaker/" + key;
    }

    public void materialize() {
        this.failOn();
        this.skipOn();
        this.delay();
        this.delayUnit();
        this.requestVolumeThreshold();
        this.failureRatio();
        this.successThreshold();
    }
}

