/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.KotlinSupport;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (System.getSecurityManager() == null) {
            accessibleObject.setAccessible(true);
            return accessibleObject;
        }
        return (T)AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return accessibleObject;
        });
    }

    static Method findFallbackMethod(Class<?> beanClass, Class<?> declaringClass, String name, Type[] parameterTypes, Type returnType) throws PrivilegedActionException {
        Set result = System.getSecurityManager() == null ? SecurityActions.findMethod(beanClass, declaringClass, name, parameterTypes, returnType, false) : AccessController.doPrivileged(() -> SecurityActions.findMethod(beanClass, declaringClass, name, parameterTypes, returnType, false));
        return result.isEmpty() ? null : (Method)result.iterator().next();
    }

    static Set<Method> findFallbackMethodsWithExceptionParameter(Class<?> beanClass, Class<?> declaringClass, String name, Type[] parameterTypes, Type returnType) throws PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            return SecurityActions.findMethod(beanClass, declaringClass, name, parameterTypes, returnType, true);
        }
        return AccessController.doPrivileged(() -> SecurityActions.findMethod(beanClass, declaringClass, name, parameterTypes, returnType, true));
    }

    static Method findBeforeRetryMethod(Class<?> beanClass, Class<?> declaringClass, String name) throws PrivilegedActionException {
        Set<Method> result = System.getSecurityManager() == null ? SecurityActions.findMethod(beanClass, declaringClass, name, new Type[0], Void.TYPE, false) : AccessController.doPrivileged(() -> SecurityActions.findMethod(beanClass, declaringClass, name, new Type[0], Void.TYPE, false));
        return result.isEmpty() ? null : result.iterator().next();
    }

    private static Set<Method> findMethod(Class<?> beanClass, Class<?> declaringClass, String name, Type[] expectedParameterTypes, Type expectedReturnType, boolean expectedExceptionParameter) {
        HashSet<Method> result = new HashSet<Method>();
        TypeMapping expectedMapping = TypeMapping.createFor(beanClass, declaringClass);
        Set<String> declaredMethodNames = SecurityActions.findDeclaredMethodNames(declaringClass);
        ArrayDeque<ClassWithTypeMapping> worklist = new ArrayDeque<ClassWithTypeMapping>();
        Class<?> clazz = beanClass;
        TypeMapping typeMapping = new TypeMapping();
        worklist.add(new ClassWithTypeMapping(clazz, typeMapping));
        while (clazz.getSuperclass() != null) {
            Class<?> superclass = clazz.getSuperclass();
            Type genericSuperclass = clazz.getGenericSuperclass();
            typeMapping = typeMapping.getDirectSupertypeMapping(superclass, genericSuperclass);
            worklist.add(new ClassWithTypeMapping(superclass, typeMapping));
            clazz = clazz.getSuperclass();
        }
        while (!worklist.isEmpty()) {
            ClassWithTypeMapping classWithTypeMapping = (ClassWithTypeMapping)worklist.removeFirst();
            Class<?> clazz2 = classWithTypeMapping.clazz;
            TypeMapping actualMapping = classWithTypeMapping.typeMapping;
            Set<Method> methods = SecurityActions.getMethodsFromClass(clazz2, name, expectedParameterTypes, expectedReturnType, expectedExceptionParameter, declaringClass, actualMapping, expectedMapping);
            for (Method method : methods) {
                if (!declaredMethodNames.contains(method.getName())) continue;
                result.add(method);
                if (expectedExceptionParameter) continue;
                return result;
            }
            for (int i = 0; i < clazz2.getInterfaces().length; ++i) {
                Class<?> iface = clazz2.getInterfaces()[i];
                Type genericIface = clazz2.getGenericInterfaces()[i];
                worklist.add(new ClassWithTypeMapping(iface, actualMapping.getDirectSupertypeMapping(iface, genericIface)));
            }
        }
        return result;
    }

    private static Set<String> findDeclaredMethodNames(Class<?> declaringClass) {
        HashSet<String> result = new HashSet<String>();
        ArrayDeque worklist = new ArrayDeque();
        worklist.add(declaringClass);
        while (!worklist.isEmpty()) {
            Class clazz = (Class)worklist.removeFirst();
            for (Method m : clazz.getDeclaredMethods()) {
                result.add(m.getName());
            }
            if (clazz.getSuperclass() != null) {
                worklist.add(clazz.getSuperclass());
            }
            Collections.addAll(worklist, clazz.getInterfaces());
        }
        return result;
    }

    private static Set<Method> getMethodsFromClass(Class<?> classToSearch, String name, Type[] parameterTypes, Type returnType, boolean exceptionParameter, Class<?> guardedMethodDeclaringClass, TypeMapping actualMapping, TypeMapping expectedMapping) {
        HashSet<Method> set = new HashSet<Method>();
        for (Method method : classToSearch.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !SecurityActions.isAccessibleFrom(method, guardedMethodDeclaringClass) || !SecurityActions.signaturesMatch(method, parameterTypes, returnType, exceptionParameter, actualMapping, expectedMapping)) continue;
            set.add(method);
        }
        return set;
    }

    private static boolean isAccessibleFrom(Method method, Class<?> guardedMethodDeclaringClass) {
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        if (Modifier.isPrivate(method.getModifiers())) {
            return method.getDeclaringClass() == guardedMethodDeclaringClass;
        }
        return method.getDeclaringClass().getPackage() == guardedMethodDeclaringClass.getPackage();
    }

    private static boolean signaturesMatch(Method method, Type[] expectedParameterTypes, Type expectedReturnType, boolean expectedExceptionParameter, TypeMapping actualMapping, TypeMapping expectedMapping) {
        Type[] methodParams;
        int expectedParameters = expectedParameterTypes.length;
        if (expectedExceptionParameter) {
            boolean kotlinSuspendingFunction = KotlinSupport.isSuspendingFunction(expectedParameterTypes);
            expectedParameterTypes = Arrays.copyOfRange(expectedParameterTypes, 0, expectedParameters + 1);
            if (kotlinSuspendingFunction) {
                expectedParameterTypes[expectedParameters] = expectedParameterTypes[expectedParameters - 1];
                expectedParameterTypes[expectedParameters - 1] = null;
            }
            ++expectedParameters;
        }
        if (expectedParameters != (methodParams = method.getGenericParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < expectedParameters; ++i) {
            boolean isThrowable;
            Type methodParam = methodParams[i];
            Type expectedParamType = expectedParameterTypes[i];
            if (expectedParamType != null) {
                if (SecurityActions.typeMatches(methodParam, expectedParamType, actualMapping, expectedMapping)) continue;
                return false;
            }
            boolean bl = isThrowable = methodParam instanceof Class && Throwable.class.isAssignableFrom((Class)methodParam);
            if (isThrowable) continue;
            return false;
        }
        return SecurityActions.typeMatches(method.getGenericReturnType(), expectedReturnType, actualMapping, expectedMapping);
    }

    private static boolean typeMatches(Type actualType, Type expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        actualType = actualMapping.map(actualType);
        expectedType = expectedMapping.map(expectedType);
        if (actualType instanceof Class) {
            return expectedType == actualType;
        }
        if (SecurityActions.isArray(actualType) && SecurityActions.isArray(expectedType)) {
            return SecurityActions.typeMatches(SecurityActions.getArrayComponentType(actualType), SecurityActions.getArrayComponentType(expectedType), actualMapping, expectedMapping);
        }
        if (actualType instanceof ParameterizedType && expectedType instanceof ParameterizedType) {
            return SecurityActions.parameterizedTypeMatches((ParameterizedType)actualType, (ParameterizedType)expectedType, actualMapping, expectedMapping);
        }
        if (actualType instanceof WildcardType && expectedType instanceof WildcardType) {
            return SecurityActions.wildcardTypeMatches((WildcardType)actualType, (WildcardType)expectedType, actualMapping, expectedMapping);
        }
        return false;
    }

    private static boolean wildcardTypeMatches(WildcardType actualType, WildcardType expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        boolean lowerBoundsMatch = SecurityActions.typeArrayMatches(actualType.getLowerBounds(), expectedType.getLowerBounds(), actualMapping, expectedMapping);
        boolean upperBoundsMatch = SecurityActions.typeArrayMatches(actualType.getUpperBounds(), expectedType.getUpperBounds(), actualMapping, expectedMapping);
        return lowerBoundsMatch && upperBoundsMatch;
    }

    private static boolean parameterizedTypeMatches(ParameterizedType actualType, ParameterizedType expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        boolean genericClassMatch = SecurityActions.typeMatches(actualType.getRawType(), expectedType.getRawType(), actualMapping, expectedMapping);
        boolean typeArgumentsMatch = SecurityActions.typeArrayMatches(actualType.getActualTypeArguments(), expectedType.getActualTypeArguments(), actualMapping, expectedMapping);
        return genericClassMatch && typeArgumentsMatch;
    }

    private static boolean typeArrayMatches(Type[] actualTypes, Type[] expectedTypes, TypeMapping actualMapping, TypeMapping expectedMapping) {
        if (actualTypes.length != expectedTypes.length) {
            return false;
        }
        for (int i = 0; i < actualTypes.length; ++i) {
            if (SecurityActions.typeMatches(actualTypes[i], expectedTypes[i], actualMapping, expectedMapping)) continue;
            return false;
        }
        return true;
    }

    private static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        throw new IllegalArgumentException("Not an array: " + type);
    }

    private static boolean isArray(Type parameterType) {
        if (parameterType instanceof Class) {
            return ((Class)parameterType).isArray();
        }
        return parameterType instanceof GenericArrayType;
    }

    private static class TypeMapping {
        private final Map<Type, Type> map;

        private TypeMapping() {
            this.map = Collections.emptyMap();
        }

        private TypeMapping(Map<Type, Type> map) {
            this.map = map;
        }

        private static TypeMapping createFor(Class<?> beanClass, Class<?> declaringClass) {
            TypeMapping result = new TypeMapping();
            if (beanClass == declaringClass) {
                return result;
            }
            for (Class<?> current = beanClass; current != declaringClass && current != null && current.getSuperclass() != null; current = current.getSuperclass()) {
                result = result.getDirectSupertypeMapping(current.getSuperclass(), current.getGenericSuperclass());
            }
            return result;
        }

        private Type map(Type type) {
            Type result = this.map.get(type);
            return result != null ? result : type;
        }

        private TypeMapping getDirectSupertypeMapping(Class<?> supertype, Type genericSupertype) {
            TypeVariable<Class<?>>[] typeParameters = supertype.getTypeParameters();
            Type[] typeArguments = genericSupertype instanceof ParameterizedType ? ((ParameterizedType)genericSupertype).getActualTypeArguments() : new Type[]{};
            HashMap<Type, Type> result = new HashMap<Type, Type>();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    result.put(typeParameters[i], typeArgument);
                    continue;
                }
                Type type = this.map.get(typeArgument);
                result.put(typeParameters[i], type != null ? type : typeArgument);
            }
            return new TypeMapping(result);
        }
    }

    private static class ClassWithTypeMapping {
        private final Class<?> clazz;
        private final TypeMapping typeMapping;

        private ClassWithTypeMapping(Class<?> clazz, TypeMapping typeMapping) {
            this.clazz = clazz;
            this.typeMapping = typeMapping;
        }
    }
}

