/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.OpenTelemetryRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class OpenTelemetryProvider
implements MetricsProvider {
    @Inject
    Meter meter;
    @Inject
    @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true")
    boolean metricsEnabled;
    @Inject
    ExecutorHolder executorHolder;
    private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

    @PostConstruct
    void init() {
        if (!this.metricsEnabled) {
            return;
        }
        Timer timer = this.executorHolder.getTimer();
        Attributes attributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"id"), (Object)("" + timer.getId()));
        this.meter.upDownCounterBuilder("ft.timer.scheduled").buildWithCallback(m -> m.record((long)timer.countScheduledTasks(), attributes));
    }

    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    public MetricsRecorder create(MeteredOperation operation) {
        if (this.metricsEnabled) {
            return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new OpenTelemetryRecorder(this.meter, operation));
        }
        return MetricsRecorder.NOOP;
    }
}

