/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.RetryWhenConfig;
import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class RetryWhenConfigImpl
implements RetryWhenConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final RetryWhen instance;
    private final boolean onMethod;
    private Class<? extends Predicate<Object>> _result;
    private Class<? extends Predicate<Throwable>> _exception;

    private RetryWhenConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.retryWhen;
        this.onMethod = method.annotationsPresentDirectly.contains(RetryWhen.class);
    }

    public static RetryWhenConfigImpl create(FaultToleranceMethod method) {
        if (method.retryWhen == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(RetryWhen.class, method.method)) {
            return null;
        }
        return new RetryWhenConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return RetryWhen.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<? extends Predicate<Object>> result() {
        if (this._result == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RetryWhen.class, "result", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RetryWhen.class, "result", this.method.declaringClass, this.method.name);
                this._result = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RetryWhen.class, "result", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RetryWhen.class, "result", this.method.declaringClass);
                this._result = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._result == null) {
                newKey = ConfigUtil.newKey(RetryWhen.class, "result");
                oldKey = ConfigUtil.oldKey(RetryWhen.class, "result");
                this._result = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._result == null) {
                this._result = this.instance.result();
            }
        }
        return this._result;
    }

    public Class<? extends Predicate<Throwable>> exception() {
        if (this._exception == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RetryWhen.class, "exception", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RetryWhen.class, "exception", this.method.declaringClass, this.method.name);
                this._exception = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RetryWhen.class, "exception", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RetryWhen.class, "exception", this.method.declaringClass);
                this._exception = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._exception == null) {
                newKey = ConfigUtil.newKey(RetryWhen.class, "exception");
                oldKey = ConfigUtil.oldKey(RetryWhen.class, "exception");
                this._exception = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._exception == null) {
                this._exception = this.instance.exception();
            }
        }
        return this._exception;
    }

    public void materialize() {
        this.result();
        this.exception();
    }
}

