/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.TimeoutConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Timeout;

public final class TimeoutConfigImpl
implements TimeoutConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Timeout instance;
    private final boolean onMethod;
    private Long _value;
    private ChronoUnit _unit;

    private TimeoutConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.timeout;
        this.onMethod = method.annotationsPresentDirectly.contains(Timeout.class);
    }

    public static TimeoutConfigImpl create(FaultToleranceMethod method) {
        if (method.timeout == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(Timeout.class, method.method)) {
            return null;
        }
        return new TimeoutConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Timeout.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public long value() {
        if (this._value == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Timeout.class, "value", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Timeout.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Timeout.class, "value", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Timeout.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._value == null) {
                newKey = ConfigUtil.newKey(Timeout.class, "value");
                oldKey = ConfigUtil.oldKey(Timeout.class, "value");
                this._value = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public ChronoUnit unit() {
        if (this._unit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Timeout.class, "unit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Timeout.class, "unit", this.method.declaringClass, this.method.name);
                this._unit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Timeout.class, "unit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Timeout.class, "unit", this.method.declaringClass);
                this._unit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._unit == null) {
                newKey = ConfigUtil.newKey(Timeout.class, "unit");
                oldKey = ConfigUtil.oldKey(Timeout.class, "unit");
                this._unit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._unit == null) {
                this._unit = this.instance.unit();
            }
        }
        return this._unit;
    }

    public void materialize() {
        this.value();
        this.unit();
    }
}

