/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.format;

import org.springframework.core.convert.ConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.common.CompositeStringExpression;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.util.StringUtils;

public class EntityExpressionSupport {
    private final ExpressionParser parser;
    private final TemplateParserContext templateParserContext;
    private final String defaultExpression;
    private final ConversionService conversionService;

    public EntityExpressionSupport(ExpressionParser parser, TemplateParserContext templateParserContext) {
        this(parser, templateParserContext, null, "#{toString()}");
    }

    public EntityExpressionSupport(ExpressionParser parser, TemplateParserContext templateParserContext, ConversionService conversionService) {
        this(parser, templateParserContext, conversionService, "#{toString()}");
    }

    public EntityExpressionSupport(ExpressionParser parser, TemplateParserContext templateParserContext, String defaultExpression) {
        this(parser, templateParserContext, null, defaultExpression);
    }

    public EntityExpressionSupport(ExpressionParser parser, TemplateParserContext templateParserContext, ConversionService conversionService, String defaultExpression) {
        this.parser = parser;
        this.templateParserContext = templateParserContext;
        this.defaultExpression = defaultExpression;
        this.conversionService = conversionService;
    }

    protected String getDefaultExpression() {
        return this.defaultExpression;
    }

    protected String getExpressionOrDefault(String expression) {
        return StringUtils.isEmpty((Object)expression) ? this.getDefaultExpression() : expression;
    }

    private ExpressionParser getParser() {
        return this.parser;
    }

    private TemplateParserContext getTemplateParserContext() {
        return this.templateParserContext;
    }

    protected Expression parseExpression(String expression) {
        Expression parsedExpression = this.getParser().parseExpression(expression, (ParserContext)this.getTemplateParserContext());
        this.registerConversionServiceInSpelExpressions(parsedExpression);
        return parsedExpression;
    }

    private void registerConversionServiceInSpelExpressions(Expression parsedExpression) {
        if (this.conversionService == null) {
            return;
        }
        StandardTypeConverter converter = new StandardTypeConverter(this.conversionService);
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setTypeConverter((TypeConverter)converter);
        this.setContextIfSpelExpression(parsedExpression, context);
        if (parsedExpression instanceof CompositeStringExpression) {
            CompositeStringExpression composite = (CompositeStringExpression)parsedExpression;
            for (Expression childExpresion : composite.getExpressions()) {
                this.setContextIfSpelExpression(childExpresion, context);
            }
        }
    }

    private void setContextIfSpelExpression(Expression expression, StandardEvaluationContext context) {
        if (expression instanceof SpelExpression) {
            ((SpelExpression)expression).setEvaluationContext((EvaluationContext)context);
        }
    }

    protected String convertToString(Object entity, String expressionTxt) {
        return (String)this.parseExpression(expressionTxt).getValue(entity, String.class);
    }
}

